package models;

import javax.persistence.Embeddable;
import java.io.Serializable;

/**
 * Created by dom on 4/12/2018.
 */
@Embeddable
public class ContactInfo implements Serializable {
    @Searchable
    public String address;
    public String number;
    public String district;
    public String zipcode;
    public String landline;
    public String worknumber;
    public String fax;
    @Searchable
    public String mobile;
    @Searchable
    public String email;
    public Boolean emailBounced = false;
    public Boolean acceptEmail = true;
    public Boolean acceptSMS; //{0 or 1}
    public String replyToAddress;
    public Boolean replyToAddressVerified = false;
    public Boolean verificationSent = false;
    public String verificationToken;

    public ContactInfo() {
    }



    public ContactInfo(String district, String address, String number, String zipcode, String email,String landline, String worknumber, String fax, String mobile) {
        this.district = district;
        this.address = address;
        this.number = number;
        this.zipcode = zipcode;
        this.email = email;
        this.worknumber = worknumber;
        this.landline = landline;
        this.fax = fax;
        this.mobile = mobile;
    }
}

