/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.messaging;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.messaging.Body;
import com.twilio.twiml.messaging.Media;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Message
extends TwiML {
    private final String to;
    private final String from;
    private final URI action;
    private final HttpMethod method;
    private final URI statusCallback;
    private final String body;

    private Message() {
        this(new Builder());
    }

    private Message(Builder b) {
        super("Message", b);
        this.to = b.to;
        this.from = b.from;
        this.action = b.action;
        this.method = b.method;
        this.statusCallback = b.statusCallback;
        this.body = b.body;
    }

    @Override
    protected String getElementBody() {
        return this.getBody() == null ? null : this.getBody();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getTo() != null) {
            attrs.put("to", this.getTo());
        }
        if (this.getFrom() != null) {
            attrs.put("from", this.getFrom());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        return attrs;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public String getBody() {
        return this.body;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private String to;
        private String from;
        private URI action;
        private HttpMethod method;
        private URI statusCallback;
        private String body;

        public Builder(String body) {
            this.body = body;
        }

        public Builder() {
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        public Builder body(Body body) {
            this.children.add(body);
            return this;
        }

        public Builder media(Media media) {
            this.children.add(media);
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

