/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.credentiallist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialCreator;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialDeleter;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialFetcher;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialReader;
import com.twilio.rest.api.v2010.account.sip.credentiallist.CredentialUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Credential
extends Resource {
    private static final long serialVersionUID = 207131851434233L;
    private final String sid;
    private final String accountSid;
    private final String credentialListSid;
    private final String username;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uri;

    public static CredentialReader reader(String pathAccountSid, String pathCredentialListSid) {
        return new CredentialReader(pathAccountSid, pathCredentialListSid);
    }

    public static CredentialReader reader(String pathCredentialListSid) {
        return new CredentialReader(pathCredentialListSid);
    }

    public static CredentialCreator creator(String pathAccountSid, String pathCredentialListSid, String username, String password) {
        return new CredentialCreator(pathAccountSid, pathCredentialListSid, username, password);
    }

    public static CredentialCreator creator(String pathCredentialListSid, String username, String password) {
        return new CredentialCreator(pathCredentialListSid, username, password);
    }

    public static CredentialFetcher fetcher(String pathAccountSid, String pathCredentialListSid, String pathSid) {
        return new CredentialFetcher(pathAccountSid, pathCredentialListSid, pathSid);
    }

    public static CredentialFetcher fetcher(String pathCredentialListSid, String pathSid) {
        return new CredentialFetcher(pathCredentialListSid, pathSid);
    }

    public static CredentialUpdater updater(String pathAccountSid, String pathCredentialListSid, String pathSid) {
        return new CredentialUpdater(pathAccountSid, pathCredentialListSid, pathSid);
    }

    public static CredentialUpdater updater(String pathCredentialListSid, String pathSid) {
        return new CredentialUpdater(pathCredentialListSid, pathSid);
    }

    public static CredentialDeleter deleter(String pathAccountSid, String pathCredentialListSid, String pathSid) {
        return new CredentialDeleter(pathAccountSid, pathCredentialListSid, pathSid);
    }

    public static CredentialDeleter deleter(String pathCredentialListSid, String pathSid) {
        return new CredentialDeleter(pathCredentialListSid, pathSid);
    }

    public static Credential fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Credential fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Credential.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Credential(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="credential_list_sid") String credentialListSid, @JsonProperty(value="username") String username, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.credentialListSid = credentialListSid;
        this.username = username;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCredentialListSid() {
        return this.credentialListSid;
    }

    public final String getUsername() {
        return this.username;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.credentialListSid, other.credentialListSid) && Objects.equals(this.username, other.username) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.credentialListSid, this.username, this.dateCreated, this.dateUpdated, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("credentialListSid", this.credentialListSid).add("username", this.username).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("uri", this.uri).toString();
    }
}

