/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.logging.RollingPolicy;
import org.apache.spark.util.logging.TimeBasedRollingPolicy$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0001\u0019a!A\u0006+j[\u0016\u0014\u0015m]3e%>dG.\u001b8h!>d\u0017nY=\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tA!\u001e;jY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0003\u0001\u001bM9\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\ti!k\u001c7mS:<\u0007k\u001c7jGf\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001BA\u0002\u0013\u0005\u0001%\u0001\fs_2dwN^3s\u0013:$XM\u001d<bY6KG\u000e\\5t\u0007\u0001)\u0012!\t\t\u0003\u001d\tJ!aI\b\u0003\t1{gn\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0001M\u0005Q\"o\u001c7m_Z,'/\u00138uKJ4\u0018\r\\'jY2L7o\u0018\u0013fcR\u0011qE\u000b\t\u0003\u001d!J!!K\b\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\"\u0003\rAH%\r\u0005\t[\u0001\u0011\t\u0011)Q\u0005C\u00059\"o\u001c7m_Z,'/\u00138uKJ4\u0018\r\\'jY2L7\u000f\t\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005A\"o\u001c7mS:<g)\u001b7f'V4g-\u001b=QCR$XM\u001d8\u0011\u0005EBdB\u0001\u001a7!\t\u0019t\"D\u00015\u0015\t)t$\u0001\u0004=e>|GOP\u0005\u0003o=\ta\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011qg\u0004\u0005\ty\u0001\u0011\t\u0011)A\u0005{\u000592\r[3dW&sG/\u001a:wC2\u001cuN\\:ue\u0006Lg\u000e\u001e\t\u0003\u001dyJ!aP\b\u0003\u000f\t{w\u000e\\3b]\")\u0011\t\u0001C\u0001\u0005\u00061A(\u001b8jiz\"Ba\u0011#F\rB\u0011A\u0003\u0001\u0005\u0006=\u0001\u0003\r!\t\u0005\u0006_\u0001\u0003\r\u0001\r\u0005\by\u0001\u0003\n\u00111\u0001>\u0011\u001dA\u0005\u00011A\u0005\n\u0001\n\u0001C\\3yiJ{G\u000e\\8wKJ$\u0016.\\3\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u0006!b.\u001a=u%>dGn\u001c<feRKW.Z0%KF$\"a\n'\t\u000f-J\u0015\u0011!a\u0001C!1a\n\u0001Q!\n\u0005\n\u0011C\\3yiJ{G\u000e\\8wKJ$\u0016.\\3!Q\ti\u0005\u000b\u0005\u0002\u000f#&\u0011!k\u0004\u0002\tm>d\u0017\r^5mK\"9A\u000b\u0001b\u0001\n\u0013)\u0016!\u00034pe6\fG\u000f^3s+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0011!X\r\u001f;\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCRDaa\u0018\u0001!\u0002\u00131\u0016A\u00034pe6\fG\u000f^3sA!)\u0011\r\u0001C\u0001E\u0006q1\u000f[8vY\u0012\u0014v\u000e\u001c7pm\u0016\u0014HCA\u001fd\u0011\u0015!\u0007\r1\u0001\"\u0003A\u0011\u0017\u0010^3t)>\u0014Um\u0016:jiR,g\u000eC\u0003g\u0001\u0011\u0005q-\u0001\u0006s_2dW\rZ(wKJ$\u0012a\n\u0005\u0006S\u0002!\tA[\u0001\rEf$Xm],sSR$XM\u001c\u000b\u0003O-DQ\u0001\u001c5A\u0002\u0005\nQAY=uKNDQA\u001c\u0001\u0005\n=\f\u0011dY1mGVd\u0017\r^3OKb$(k\u001c7m_Z,'\u000fV5nKR\t\u0011\u0005C\u0003r\u0001\u0011\u0005!/\u0001\u000fhK:,'/\u0019;f%>dG.\u001a3Pm\u0016\u0014h)\u001b7f'V4g-\u001b=\u0015\u0003A:a\u0001\u001e\u0002\t\u0002\u0019)\u0018A\u0006+j[\u0016\u0014\u0015m]3e%>dG.\u001b8h!>d\u0017nY=\u0011\u0005Q1hAB\u0001\u0003\u0011\u00031qo\u0005\u0002w\u001b!)\u0011I\u001eC\u0001sR\tQ\u000fC\u0004|m\n\u0007I\u0011\u0001\u0011\u000215Ke*S'V\u001b~Ke\nV#S-\u0006culU#D\u001f:#5\u000b\u0003\u0004~m\u0002\u0006I!I\u0001\u001a\u001b&s\u0015*T+N?&sE+\u0012*W\u00032{6+R\"P\u001d\u0012\u001b\u0006\u0005\u0003\u0005\u0000mF\u0005I\u0011AA\u0001\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0001\u0016\u0004{\u0005\u00151FAA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Eq\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0006\u0002\f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TimeBasedRollingPolicy
implements RollingPolicy,
Logging {
    private long rolloverIntervalMillis;
    private volatile long nextRolloverTime;
    private final SimpleDateFormat formatter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$3() {
        return TimeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$3();
    }

    public static long MINIMUM_INTERVAL_SECONDS() {
        return TimeBasedRollingPolicy$.MODULE$.MINIMUM_INTERVAL_SECONDS();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long rolloverIntervalMillis() {
        return this.rolloverIntervalMillis;
    }

    public void rolloverIntervalMillis_$eq(long x$1) {
        this.rolloverIntervalMillis = x$1;
    }

    private long nextRolloverTime() {
        return this.nextRolloverTime;
    }

    private void nextRolloverTime_$eq(long x$1) {
        this.nextRolloverTime = x$1;
    }

    private SimpleDateFormat formatter() {
        return this.formatter;
    }

    @Override
    public boolean shouldRollover(long bytesToBeWritten) {
        return System.currentTimeMillis() > this.nextRolloverTime();
    }

    @Override
    public void rolledOver() {
        this.nextRolloverTime_$eq(this.calculateNextRolloverTime());
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(36).append("Current time: ").append(System.currentTimeMillis()).append(", next rollover time: ").append(this.nextRolloverTime()).toString());
    }

    @Override
    public void bytesWritten(long bytes) {
    }

    /*
     * WARNING - void declaration
     */
    private long calculateNextRolloverTime() {
        void var3_2;
        long now = System.currentTimeMillis();
        long targetTime = (long)(package$.MODULE$.ceil((double)now / (double)this.rolloverIntervalMillis()) * (double)this.rolloverIntervalMillis());
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(22).append("Next rollover time is ").append(targetTime).toString());
        return (long)var3_2;
    }

    @Override
    public String generateRolledOverFileSuffix() {
        return this.formatter().format(Calendar.getInstance().getTime());
    }

    public TimeBasedRollingPolicy(long rolloverIntervalMillis, String rollingFileSuffixPattern, boolean checkIntervalConstraint) {
        this.rolloverIntervalMillis = rolloverIntervalMillis;
        Logging.$init$(this);
        if (checkIntervalConstraint && this.rolloverIntervalMillis() < TimeBasedRollingPolicy$.MODULE$.MINIMUM_INTERVAL_SECONDS() * 1000L) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(42).append("Rolling interval [").append(this.rolloverIntervalMillis() / 1000L).append(" seconds] is too small. ").append(new StringBuilder(59).append("Setting the interval to the acceptable minimum of ").append(TimeBasedRollingPolicy$.MODULE$.MINIMUM_INTERVAL_SECONDS()).append(" seconds.").toString()).toString());
            this.rolloverIntervalMillis_$eq(TimeBasedRollingPolicy$.MODULE$.MINIMUM_INTERVAL_SECONDS() * 1000L);
        }
        this.nextRolloverTime = this.calculateNextRolloverTime();
        this.formatter = new SimpleDateFormat(rollingFileSuffixPattern, Locale.US);
    }
}

