/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.storage.BlockTableRowData;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4Q!\u0001\u0002\u0001\t1\u0011qB\u00117pG.$\u0015\r^1T_V\u00148-\u001a\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005\u0011Q/\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001d=\tR\"\u0001\u0003\n\u0005A!!a\u0004)bO\u0016$G)\u0019;b'>,(oY3\u0011\u0005I\u0019R\"\u0001\u0002\n\u0005Q\u0011!!\u0005\"m_\u000e\\G+\u00192mKJ{w\u000fR1uC\"Aa\u0003\u0001B\u0001B\u0003%\u0001$A\u0007sI\u0012\u0004\u0016M\u001d;ji&|gn]\u0002\u0001!\rI2E\n\b\u00035\u0001r!a\u0007\u0010\u000e\u0003qQ!!H\f\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012!B:dC2\f\u0017BA\u0011#\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aH\u0005\u0003I\u0015\u00121aU3r\u0015\t\t#\u0005\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u0005\u0011a/\r\u0006\u0003W1\n1!\u00199j\u0015\tic!\u0001\u0004ti\u0006$Xo]\u0005\u0003_!\u0012\u0001C\u0015#E!\u0006\u0014H/\u001b;j_:LeNZ8\t\u0013E\u0002!\u0011!Q\u0001\nI2\u0014\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\u0005M\"T\"\u0001\u0012\n\u0005U\u0012#aA%oi&\u0011\u0011g\u0004\u0005\tq\u0001\u0011\t\u0011)A\u0005s\u0005Q1o\u001c:u\u0007>dW/\u001c8\u0011\u0005irdBA\u001e=!\tY\"%\u0003\u0002>E\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\ti$\u0005\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0003\u0011!Wm]2\u0011\u0005M\"\u0015BA##\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\u0014Kb,7-\u001e;pe&#Gk\\!eIJ,7o\u001d\t\u0005u%K\u0014(\u0003\u0002K\u0001\n\u0019Q*\u00199\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\u0019qu\nU)S'B\u0011!\u0003\u0001\u0005\u0006--\u0003\r\u0001\u0007\u0005\u0006c-\u0003\rA\r\u0005\u0006q-\u0003\r!\u000f\u0005\u0006\u0005.\u0003\ra\u0011\u0005\u0006\u000f.\u0003\r\u0001\u0013\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0003\u0011!\u0017\r^1\u0016\u0003]\u00032\u0001W.\u0012\u001b\u0005I&B\u0001.#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003IeCa!\u0018\u0001!\u0002\u00139\u0016!\u00023bi\u0006\u0004\u0003\"B0\u0001\t\u0003\u0002\u0017\u0001\u00033bi\u0006\u001c\u0016N_3\u0016\u0003IBQA\u0019\u0001\u0005B\r\f\u0011b\u001d7jG\u0016$\u0015\r^1\u0015\u0007\u0011,w\rE\u0002\u001aGEAQAZ1A\u0002I\nAA\u001a:p[\")\u0001.\u0019a\u0001e\u0005\u0011Ao\u001c\u0005\u0006U\u0002!Ia[\u0001\tE2|7m\u001b*poR\u0011\u0011\u0003\u001c\u0005\u0006[&\u0004\rAJ\u0001\re\u0012$\u0007+\u0019:uSRLwN\u001c\u0005\u0006_\u0002!I\u0001]\u0001\t_J$WM]5oOR\u0019\u0011\u000f^;\u0011\u0007e\u0011\u0018#\u0003\u0002tK\tAqJ\u001d3fe&tw\rC\u00039]\u0002\u0007\u0011\bC\u0003C]\u0002\u00071\t")
public class BlockDataSource
extends PagedDataSource<BlockTableRowData> {
    private final Map<String, String> executorIdToAddress;
    private final Seq<BlockTableRowData> data;

    private Seq<BlockTableRowData> data() {
        return this.data;
    }

    @Override
    public int dataSize() {
        return this.data().size();
    }

    @Override
    public Seq<BlockTableRowData> sliceData(int from, int to) {
        return (Seq)this.data().slice(from, to);
    }

    private BlockTableRowData blockRow(RDDPartitionInfo rddPartition) {
        return new BlockTableRowData(rddPartition.blockName(), rddPartition.storageLevel(), rddPartition.memoryUsed(), rddPartition.diskUsed(), ((TraversableOnce)((SeqLike)rddPartition.executors().map((Function1 & java.io.Serializable & Serializable)id -> (String)$this.executorIdToAddress.get(id).getOrElse((Function0 & java.io.Serializable & Serializable)() -> id), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(" "));
    }

    private Ordering<BlockTableRowData> ordering(String sortColumn, boolean desc) {
        Ordering ordering;
        String string = sortColumn;
        if ("Block Name".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & java.io.Serializable & Serializable)x$7 -> x$7.blockName(), (Ordering)Ordering.String$.MODULE$);
        } else if ("Storage Level".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & java.io.Serializable & Serializable)x$8 -> x$8.storageLevel(), (Ordering)Ordering.String$.MODULE$);
        } else if ("Size in Memory".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.memoryUsed()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Size on Disk".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & java.io.Serializable & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.diskUsed()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Executors".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & java.io.Serializable & Serializable)x$11 -> x$11.executors(), (Ordering)Ordering.String$.MODULE$);
        } else {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(string).toString());
        }
        Ordering ordering2 = ordering;
        return desc ? ordering2.reverse() : ordering2;
    }

    public BlockDataSource(Seq<RDDPartitionInfo> rddPartitions, int pageSize, String sortColumn, boolean desc, Map<String, String> executorIdToAddress) {
        this.executorIdToAddress = executorIdToAddress;
        super(pageSize);
        this.data = (Seq)((SeqLike)rddPartitions.map((Function1 & java.io.Serializable & Serializable)rddPartition -> this.blockRow((RDDPartitionInfo)rddPartition), Seq$.MODULE$.canBuildFrom())).sorted(this.ordering(sortColumn, desc));
    }
}

