/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.NettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.OnStart$;
import org.apache.spark.rpc.netty.OnStop$;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\u0001\u0003\u0001\ta!!B%oE>D(BA\u0002\u0005\u0003\u0015qW\r\u001e;z\u0015\t)a!A\u0002sa\u000eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0019+\t9Aj\\4hS:<\u0007\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u0017\u0015tG\r]8j]R\u0014VMZ\u0002\u0001+\u0005i\u0002C\u0001\u0010 \u001b\u0005\u0011\u0011B\u0001\u0011\u0003\u0005MqU\r\u001e;z%B\u001cWI\u001c3q_&tGOU3g\u0011!\u0011\u0003A!A!\u0002\u0013i\u0012\u0001D3oIB|\u0017N\u001c;SK\u001a\u0004\u0003\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002\u0011\u0015tG\r]8j]R,\u0012A\n\t\u0003O!j\u0011\u0001B\u0005\u0003S\u0011\u00111B\u00159d\u000b:$\u0007o\\5oi\"A1\u0006\u0001B\u0001B\u0003%a%A\u0005f]\u0012\u0004x.\u001b8uA!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\tq\u0002\u0001C\u0003\u001bY\u0001\u0007Q\u0004C\u0003%Y\u0001\u0007a\u0005C\u00044\u0001\t\u0007I\u0011\u0003\u001b\u0002\u00115,7o]1hKN,\u0012!\u000e\t\u0004mmjT\"A\u001c\u000b\u0005aJ\u0014\u0001B;uS2T\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=o\tQA*\u001b8lK\u0012d\u0015n\u001d;\u0011\u0005yq\u0014BA \u0003\u00051IeNY8y\u001b\u0016\u001c8/Y4f\u0011\u0019\t\u0005\u0001)A\u0005k\u0005IQ.Z:tC\u001e,7\u000f\t\u0015\u0005\u0001\u000eke\n\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005!K\u0015AC1o]>$\u0018\r^5p]*\t!*A\u0003kCZ\f\u00070\u0003\u0002M\u000b\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002\u001f\u0006!A\u000f[5t\u0011\u001d\t\u0006\u00011A\u0005\nI\u000bqa\u001d;paB,G-F\u0001T!\tqA+\u0003\u0002V\u001f\t9!i\\8mK\u0006t\u0007bB,\u0001\u0001\u0004%I\u0001W\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011aBW\u0005\u00037>\u0011A!\u00168ji\"9QLVA\u0001\u0002\u0004\u0019\u0016a\u0001=%c!1q\f\u0001Q!\nM\u000b\u0001b\u001d;paB,G\r\t\u0015\u0005=\u000eke\nC\u0004c\u0001\u0001\u0007I\u0011\u0002*\u0002!\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$\bb\u00023\u0001\u0001\u0004%I!Z\u0001\u0015K:\f'\r\\3D_:\u001cWO\u001d:f]R|F%Z9\u0015\u0005e3\u0007bB/d\u0003\u0003\u0005\ra\u0015\u0005\u0007Q\u0002\u0001\u000b\u0015B*\u0002#\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$\b\u0005\u000b\u0003h\u00076s\u0005bB6\u0001\u0001\u0004%I\u0001\\\u0001\u0011]Vl\u0017i\u0019;jm\u0016$\u0006N]3bIN,\u0012!\u001c\t\u0003\u001d9L!a\\\b\u0003\u0007%sG\u000fC\u0004r\u0001\u0001\u0007I\u0011\u0002:\u0002)9,X.Q2uSZ,G\u000b\u001b:fC\u0012\u001cx\fJ3r)\tI6\u000fC\u0004^a\u0006\u0005\t\u0019A7\t\rU\u0004\u0001\u0015)\u0003n\u0003EqW/\\!di&4X\r\u00165sK\u0006$7\u000f\t\u0015\u0005i\u000eke\nC\u0003y\u0001\u0011\u0005\u00110A\u0004qe>\u001cWm]:\u0015\u0005eS\b\"B>x\u0001\u0004a\u0018A\u00033jgB\fGo\u00195feB\u0011a$`\u0005\u0003}\n\u0011!\u0002R5ta\u0006$8\r[3s\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\tA\u0001]8tiR\u0019\u0011,!\u0002\t\r\u0005\u001dq\u00101\u0001>\u0003\u001diWm]:bO\u0016Dq!a\u0003\u0001\t\u0003\ti!\u0001\u0003ti>\u0004H#A-\t\r\u0005E\u0001\u0001\"\u0001S\u0003\u001dI7/R7qifDq!!\u0006\u0001\t#\t9\"\u0001\u0004p]\u0012\u0013x\u000e\u001d\u000b\u00043\u0006e\u0001bBA\u0004\u0003'\u0001\r!\u0010\u0005\b\u0003;\u0001A\u0011BA\u0010\u0003)\u0019\u0018MZ3ms\u000e\u000bG\u000e\u001c\u000b\u0005\u0003C\ti\u0003F\u0002Z\u0003GA\u0011\"!\n\u0002\u001c\u0011\u0005\r!a\n\u0002\r\u0005\u001cG/[8o!\u0011q\u0011\u0011F-\n\u0007\u0005-rB\u0001\u0005=Eft\u0017-\\3?\u0011\u0019!\u00131\u0004a\u0001M\u0001")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    BoxedUnit boxedUnit;
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        boxedUnit = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                            throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                        });
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            context.sendFailure(e);
                            throw e;
                        }
                        throw throwable;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit boxedUnit = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                        throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                    });
                } else if (OnStart$.MODULE$.equals(inboxMessage)) {
                    BoxedUnit boxedUnit;
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)inboxMessage);
                }
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (this.stopped()) {
                this.onDrop(message);
                object = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                object = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    BoxedUnit boxedUnit2;
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable3;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
            }
            throw throwable;
        }
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

