/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.SnappyCompressionCodec$;
import org.apache.spark.io.SnappyOutputStreamWrapper;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0017\t12K\\1qaf\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7M\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t\r|gN\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0014\u0001!)q\u0003\ba\u00011!9!\u0005\u0001b\u0001\n\u0003\u0019\u0013a\u0002<feNLwN\\\u000b\u0002IA\u0011Q\u0005\f\b\u0003M)\u0002\"a\n\b\u000e\u0003!R!!\u000b\u0006\u0002\rq\u0012xn\u001c;?\u0013\tYc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016\u000f\u0011\u0019\u0001\u0004\u0001)A\u0005I\u0005Aa/\u001a:tS>t\u0007\u0005C\u00033\u0001\u0011\u00053'\u0001\fd_6\u0004(/Z:tK\u0012|U\u000f\u001e9viN#(/Z1n)\t!4\b\u0005\u00026s5\taG\u0003\u0002\u0004o)\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e7\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u0015a\u0014\u00071\u00015\u0003\u0005\u0019\b\"\u0002 \u0001\t\u0003z\u0014!F2p[B\u0014Xm]:fI&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003\u0001\u000e\u0003\"!N!\n\u0005\t3$aC%oaV$8\u000b\u001e:fC6DQ\u0001P\u001fA\u0002\u0001C#\u0001A#\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0011AC1o]>$\u0018\r^5p]&\u0011!j\u0012\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0004\u0006\u0019\nAi!T\u0001\u0017':\f\u0007\u000f]=D_6\u0004(/Z:tS>t7i\u001c3fGB\u00111C\u0014\u0004\u0006\u0003\tAiaT\n\u0003\u001d2AQ!\b(\u0005\u0002E#\u0012!\u0014\u0005\tE9C)\u0019!C\u0005G\u0001")
public class SnappyCompressionCodec
implements CompressionCodec {
    private final SparkConf conf;
    private final String version;

    public String version() {
        return this.version;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        int blockSize = (int)this.conf.getSizeAsBytes("spark.io.compression.snappy.blockSize", "32k");
        return new SnappyOutputStreamWrapper(new SnappyOutputStream(s, blockSize));
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new SnappyInputStream(s);
    }

    public SnappyCompressionCodec(SparkConf conf) {
        this.conf = conf;
        this.version = SnappyCompressionCodec$.MODULE$.org$apache$spark$io$SnappyCompressionCodec$$version();
    }
}

