/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.CollectionAccumulator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0001\r1\u00111\u0003U=uQ>t\u0017iY2v[Vd\u0017\r^8s-JR!a\u0001\u0003\u0002\rALH\u000f[8o\u0015\t)a!A\u0002ba&T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015a\u0002c\u0001\b\u0012'5\tqB\u0003\u0002\u0011\r\u0005!Q\u000f^5m\u0013\t\u0011rBA\u000bD_2dWm\u0019;j_:\f5mY;nk2\fGo\u001c:\u0011\u0007Q9\u0012$D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0015\t%O]1z!\t!\"$\u0003\u0002\u001c+\t!!)\u001f;f!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0005j]R,'O\\1m\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0002!Q1A\u0005\n\u0015\n!b]3sm\u0016\u0014\bj\\:u\u0007\u0001)\u0012A\n\t\u0003O9r!\u0001\u000b\u0017\u0011\u0005%*R\"\u0001\u0016\u000b\u0005-\"\u0013A\u0002\u001fs_>$h(\u0003\u0002.+\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\tiS\u0003\u0003\u00053\u0001\t\u0005\t\u0015!\u0003'\u0003-\u0019XM\u001d<fe\"{7\u000f\u001e\u0011)\u0005E\"\u0004C\u0001\u000b6\u0013\t1TCA\u0005ue\u0006t7/[3oi\"A\u0001\b\u0001BC\u0002\u0013%\u0011(\u0001\u0006tKJ4XM\u001d)peR,\u0012A\u000f\t\u0003)mJ!\u0001P\u000b\u0003\u0007%sG\u000f\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003;\u0003-\u0019XM\u001d<feB{'\u000f\u001e\u0011\t\u0011\u0001\u0003!Q1A\u0005\n\u0015\n1b]3de\u0016$Hk\\6f]\"A!\t\u0001B\u0001B\u0003%a%\u0001\u0007tK\u000e\u0014X\r\u001e+pW\u0016t\u0007\u0005C\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\u0005\r\"K%\n\u0005\u0002H\u00015\t!\u0001C\u0003$\u0007\u0002\u0007a\u0005C\u00039\u0007\u0002\u0007!\bC\u0003A\u0007\u0002\u0007a\u0005C\u0004M\u0001\t\u0007I\u0011A\u001d\u0002\u0015\t,hMZ3s'&TX\r\u0003\u0004O\u0001\u0001\u0006IAO\u0001\fEV4g-\u001a:TSj,\u0007\u0005C\u0005Q\u0001\u0001\u0007\t\u0019!C\u0005#\u000611o\\2lKR,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b1A\\3u\u0015\u00059\u0016\u0001\u00026bm\u0006L!!\u0017+\u0003\rM{7m[3u\u0011%Y\u0006\u00011AA\u0002\u0013%A,\u0001\u0006t_\u000e\\W\r^0%KF$\"!\u00181\u0011\u0005Qq\u0016BA0\u0016\u0005\u0011)f.\u001b;\t\u000f\u0005T\u0016\u0011!a\u0001%\u0006\u0019\u0001\u0010J\u0019\t\u0013\r\u0004\u0001\u0019!A!B\u0013\u0011\u0016aB:pG.,G\u000f\t\u0015\u0003ERBQA\u001a\u0001\u0005\n\u001d\f!b\u001c9f]N{7m[3u)\u0005\u0011\u0006\"B5\u0001\t\u0003R\u0017\u0001D2paf\fe\u000e\u001a*fg\u0016$H#\u0001$\t\u000b1\u0004A\u0011I7\u0002\u000b5,'oZ3\u0015\u0005us\u0007\"B8l\u0001\u0004\u0001\u0018!B8uQ\u0016\u0014\b\u0003\u0002\br'ML!A]\b\u0003\u001b\u0005\u001b7-^7vY\u0006$xN\u001d,3!\r!hoE\u0007\u0002k*\u0011\u0001CV\u0005\u0003oV\u0014A\u0001T5ti\u0002")
public class PythonAccumulatorV2
extends CollectionAccumulator<byte[]>
implements Logging {
    private final transient String serverHost;
    private final int serverPort;
    private final String secretToken;
    private final int bufferSize;
    private transient Socket socket;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String serverHost() {
        return this.serverHost;
    }

    private int serverPort() {
        return this.serverPort;
    }

    private String secretToken() {
        return this.secretToken;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private Socket socket() {
        return this.socket;
    }

    private void socket_$eq(Socket x$1) {
        this.socket = x$1;
    }

    private synchronized Socket openSocket() {
        block0: {
            if (this.socket() != null && !this.socket().isClosed()) break block0;
            this.socket_$eq(new Socket(this.serverHost(), this.serverPort()));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Connected to AccumulatorServer at host: ").append(this.serverHost()).append(" port: ").append(this.serverPort()).toString());
            this.socket().getOutputStream().write(this.secretToken().getBytes(StandardCharsets.UTF_8));
        }
        return this.socket();
    }

    @Override
    public PythonAccumulatorV2 copyAndReset() {
        return new PythonAccumulatorV2(this.serverHost(), this.serverPort(), this.secretToken());
    }

    @Override
    public synchronized void merge(AccumulatorV2<byte[], List<byte[]>> other) {
        PythonAccumulatorV2 otherPythonAccumulator = (PythonAccumulatorV2)other;
        if (this.serverHost() == null) {
            super.merge(otherPythonAccumulator);
        } else {
            Socket socket = this.openSocket();
            InputStream in = socket.getInputStream();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), this.bufferSize()));
            List<byte[]> values = other.value();
            out.writeInt(values.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()).foreach((Function1 & Serializable & scala.Serializable)array -> {
                PythonAccumulatorV2.$anonfun$merge$1(out, array);
                return BoxedUnit.UNIT;
            });
            out.flush();
            int byteRead = in.read();
            if (byteRead == -1) {
                throw new SparkException("EOF reached before Python server acknowledged");
            }
        }
    }

    public static final /* synthetic */ void $anonfun$merge$1(DataOutputStream out$2, byte[] array) {
        out$2.writeInt(array.length);
        out$2.write(array);
    }

    public PythonAccumulatorV2(String serverHost, int serverPort, String secretToken) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.secretToken = secretToken;
        Logging.$init$(this);
        Utils$.MODULE$.checkHost(serverHost);
        this.bufferSize = SparkEnv$.MODULE$.get().conf().getInt("spark.buffer.size", 65536);
    }
}

