/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.MapOutputTrackerMasterEndpoint;
import org.apache.spark.MapOutputTrackerWorker;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.StaticMemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.network.netty.NettyBlockTransferService;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMasterEndpoint;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class SparkEnv$
implements Logging {
    public static SparkEnv$ MODULE$;
    private volatile SparkEnv env;
    private final String driverSystemName;
    private final String executorSystemName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkEnv$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    public String driverSystemName() {
        return this.driverSystemName;
    }

    public String executorSystemName() {
        return this.executorSystemName;
    }

    public void set(SparkEnv e) {
        this.env_$eq(e);
    }

    public SparkEnv get() {
        return this.env();
    }

    public SparkEnv createDriverEnv(SparkConf conf, boolean isLocal, LiveListenerBus listenerBus, int numCores, Option<OutputCommitCoordinator> mockOutputCommitCoordinator) {
        Predef$.MODULE$.assert(conf.contains(package$.MODULE$.DRIVER_HOST_ADDRESS()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(package$.MODULE$.DRIVER_HOST_ADDRESS().key()).append(" is not set on the driver!").toString());
        Predef$.MODULE$.assert(conf.contains("spark.driver.port"), (Function0 & Serializable & scala.Serializable)() -> "spark.driver.port is not set on the driver!");
        String bindAddress = conf.get(package$.MODULE$.DRIVER_BIND_ADDRESS());
        String advertiseAddress = conf.get(package$.MODULE$.DRIVER_HOST_ADDRESS());
        int port = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.driver.port"))).toInt();
        None$ ioEncryptionKey = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_ENABLED())) ? new Some((Object)CryptoStreamUtils$.MODULE$.createKey(conf)) : None$.MODULE$;
        return this.create(conf, SparkContext$.MODULE$.DRIVER_IDENTIFIER(), bindAddress, advertiseAddress, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port)), isLocal, numCores, (Option<byte[]>)ioEncryptionKey, listenerBus, mockOutputCommitCoordinator);
    }

    public SparkEnv createExecutorEnv(SparkConf conf, String executorId, String hostname, int numCores, Option<byte[]> ioEncryptionKey, boolean isLocal) {
        SparkEnv env = this.create(conf, executorId, hostname, hostname, (Option<Object>)None$.MODULE$, isLocal, numCores, ioEncryptionKey, this.create$default$9(), this.create$default$10());
        this.set(env);
        return env;
    }

    private SparkEnv create(SparkConf conf, String executorId, String bindAddress, String advertiseAddress, Option<Object> port, boolean isLocal, int numUsableCores, Option<byte[]> ioEncryptionKey, LiveListenerBus listenerBus, Option<OutputCommitCoordinator> mockOutputCommitCoordinator) {
        SparkEnv envInstance;
        block4: {
            MetricsSystem metricsSystem;
            boolean isDriver;
            String string = executorId;
            String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isDriver = false);
            if (isDriver) {
                Predef$.MODULE$.assert(listenerBus != null, (Function0 & Serializable & scala.Serializable)() -> "Attempted to create driver SparkEnv with null listener bus!");
            }
            SecurityManager securityManager = new SecurityManager(conf, ioEncryptionKey);
            if (isDriver) {
                securityManager.initializeAuth();
            }
            ioEncryptionKey.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                SparkEnv$.$anonfun$create$2(securityManager, x$4);
                return BoxedUnit.UNIT;
            });
            String systemName = isDriver ? this.driverSystemName() : this.executorSystemName();
            RpcEnv rpcEnv = RpcEnv$.MODULE$.create(systemName, bindAddress, advertiseAddress, BoxesRunTime.unboxToInt((Object)port.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), conf, securityManager, numUsableCores, !isDriver);
            Object object = isDriver ? conf.set("spark.driver.port", ((Object)BoxesRunTime.boxToInteger((int)rpcEnv.address().port())).toString()) : BoxedUnit.UNIT;
            Serializer serializer = (Serializer)SparkEnv$.instantiateClassFromConf$1("spark.serializer", "org.apache.spark.serializer.JavaSerializer", conf, isDriver);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Using serializer: ").append(serializer.getClass()).toString());
            SerializerManager serializerManager = new SerializerManager(serializer, conf, ioEncryptionKey);
            JavaSerializer closureSerializer = new JavaSerializer(conf);
            BroadcastManager broadcastManager = new BroadcastManager(isDriver, conf, securityManager);
            MapOutputTracker mapOutputTracker = isDriver ? new MapOutputTrackerMaster(conf, broadcastManager, isLocal) : new MapOutputTrackerWorker(conf);
            mapOutputTracker.trackerEndpoint_$eq(this.registerOrLookupEndpoint$1(MapOutputTracker$.MODULE$.ENDPOINT_NAME(), (Function0 & Serializable & scala.Serializable)() -> new MapOutputTrackerMasterEndpoint(rpcEnv, (MapOutputTrackerMaster)mapOutputTracker, conf), conf, isDriver, rpcEnv));
            Map shortShuffleMgrNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sort"), (Object)SortShuffleManager.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tungsten-sort"), (Object)SortShuffleManager.class.getName())}));
            String shuffleMgrName = conf.get("spark.shuffle.manager", "sort");
            String shuffleMgrClass = (String)shortShuffleMgrNames.getOrElse((Object)shuffleMgrName.toLowerCase(Locale.ROOT), (Function0 & Serializable & scala.Serializable)() -> shuffleMgrName);
            ShuffleManager shuffleManager = (ShuffleManager)SparkEnv$.instantiateClass$1(shuffleMgrClass, conf, isDriver);
            boolean useLegacyMemoryManager = conf.getBoolean("spark.memory.useLegacyMode", false);
            MemoryManager memoryManager = useLegacyMemoryManager ? new StaticMemoryManager(conf, numUsableCores) : UnifiedMemoryManager$.MODULE$.apply(conf, numUsableCores);
            int blockManagerPort = isDriver ? BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT())) : BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.BLOCK_MANAGER_PORT()));
            NettyBlockTransferService blockTransferService = new NettyBlockTransferService(conf, securityManager, bindAddress, advertiseAddress, blockManagerPort, numUsableCores);
            BlockManagerMaster blockManagerMaster = new BlockManagerMaster(this.registerOrLookupEndpoint$1(BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME(), (Function0 & Serializable & scala.Serializable)() -> new BlockManagerMasterEndpoint(rpcEnv, isLocal, conf, listenerBus), conf, isDriver, rpcEnv), conf, isDriver);
            BlockManager blockManager = new BlockManager(executorId, rpcEnv, blockManagerMaster, serializerManager, conf, memoryManager, mapOutputTracker, shuffleManager, blockTransferService, securityManager, numUsableCores);
            if (isDriver) {
                metricsSystem = MetricsSystem$.MODULE$.createMetricsSystem("driver", conf, securityManager);
            } else {
                conf.set("spark.executor.id", executorId);
                MetricsSystem ms = MetricsSystem$.MODULE$.createMetricsSystem("executor", conf, securityManager);
                ms.start();
                metricsSystem = ms;
            }
            MetricsSystem metricsSystem2 = metricsSystem;
            OutputCommitCoordinator outputCommitCoordinator = (OutputCommitCoordinator)mockOutputCommitCoordinator.getOrElse((Function0 & Serializable & scala.Serializable)() -> new OutputCommitCoordinator(conf, isDriver));
            RpcEndpointRef outputCommitCoordinatorRef = this.registerOrLookupEndpoint$1("OutputCommitCoordinator", (Function0 & Serializable & scala.Serializable)() -> new OutputCommitCoordinator.OutputCommitCoordinatorEndpoint(rpcEnv, outputCommitCoordinator), conf, isDriver, rpcEnv);
            outputCommitCoordinator.coordinatorRef_$eq((Option<RpcEndpointRef>)new Some((Object)outputCommitCoordinatorRef));
            envInstance = new SparkEnv(executorId, rpcEnv, serializer, closureSerializer, serializerManager, mapOutputTracker, shuffleManager, broadcastManager, blockManager, securityManager, metricsSystem2, memoryManager, outputCommitCoordinator, conf);
            if (!isDriver) break block4;
            String sparkFilesDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.getLocalDir(conf), "userFiles").getAbsolutePath();
            envInstance.driverTmpDir_$eq((Option<String>)new Some((Object)sparkFilesDir));
        }
        return envInstance;
    }

    public Option<OutputCommitCoordinator> createDriverEnv$default$5() {
        return None$.MODULE$;
    }

    private LiveListenerBus create$default$9() {
        return null;
    }

    private Option<OutputCommitCoordinator> create$default$10() {
        return None$.MODULE$;
    }

    public Map<String, Seq<Tuple2<String, String>>> environmentDetails(SparkConf conf, String schedulingMode, Seq<String> addedJars, Seq<String> addedFiles) {
        Seq jvmInformation = (Seq)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Java Version", (Object)new StringBuilder(3).append(Properties$.MODULE$.javaVersion()).append(" (").append(Properties$.MODULE$.javaVendor()).append(")").toString()), new Tuple2((Object)"Java Home", (Object)Properties$.MODULE$.javaHome()), new Tuple2((Object)"Scala Version", (Object)Properties$.MODULE$.versionString())}))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq schedulerMode = !conf.contains("spark.scheduler.mode") ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.scheduler.mode", (Object)schedulingMode)})) : (Seq)Seq$.MODULE$.empty();
        Tuple2[] sparkProperties = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).$plus$plus((GenTraversableOnce)schedulerMode, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq systemProperties = Utils$.MODULE$.getSystemProperties().toSeq();
        Seq otherProperties = (Seq)((SeqLike)systemProperties.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkEnv$.$anonfun$environmentDetails$1(x0$1)))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Tuple2[] classPathEntries = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Properties$.MODULE$.javaClassPath().split(File.pathSeparator))).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty())))).map((Function1 & Serializable & scala.Serializable)x$6 -> new Tuple2(x$6, (Object)"System Classpath"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Seq addedJarsAndFiles = (Seq)((TraversableLike)addedJars.$plus$plus(addedFiles, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(x$7, (Object)"Added By User"), Seq$.MODULE$.canBuildFrom());
        Seq classPaths = (Seq)((SeqLike)addedJarsAndFiles.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classPathEntries)), Seq$.MODULE$.canBuildFrom())).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM Information"), (Object)jvmInformation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Properties"), (Object)Predef$.MODULE$.wrapRefArray((Object[])sparkProperties)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"System Properties"), (Object)otherProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Classpath Entries"), (Object)classPaths)}));
    }

    public static final /* synthetic */ void $anonfun$create$2(SecurityManager securityManager$1, byte[] x$4) {
        block0: {
            if (securityManager$1.isEncryptionEnabled()) break block0;
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "I/O encryption enabled without RPC encryption: keys will be visible on the wire.");
        }
    }

    private static final Object instantiateClass$1(String className, SparkConf conf$1, boolean isDriver$1) {
        Object obj;
        Class<?> cls = Utils$.MODULE$.classForName(className);
        try {
            obj = cls.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf$1, new Boolean(isDriver$1));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                obj = cls.getConstructor(SparkConf.class).newInstance(conf$1);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return obj;
    }

    private static final Object instantiateClassFromConf$1(String propertyName, String defaultClassName, SparkConf conf$1, boolean isDriver$1) {
        return SparkEnv$.instantiateClass$1(conf$1.get(propertyName, defaultClassName), conf$1, isDriver$1);
    }

    private final RpcEndpointRef registerOrLookupEndpoint$1(String name, Function0 endpointCreator, SparkConf conf$1, boolean isDriver$1, RpcEnv rpcEnv$1) {
        RpcEndpointRef rpcEndpointRef;
        if (isDriver$1) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Registering ").append(name).toString());
            rpcEndpointRef = rpcEnv$1.setupEndpoint(name, (RpcEndpoint)endpointCreator.apply());
        } else {
            rpcEndpointRef = RpcUtils$.MODULE$.makeDriverRef(name, conf$1, rpcEnv$1);
        }
        return rpcEndpointRef;
    }

    public static final /* synthetic */ boolean $anonfun$environmentDetails$1(Tuple2 x0$1) {
        String k;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = k = (String)tuple2._1();
        String string2 = "java.class.path";
        boolean bl = (string == null ? string2 != null : !string.equals(string2)) && !k.startsWith("spark.");
        return bl;
    }

    private SparkEnv$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.driverSystemName = "sparkDriver";
        this.executorSystemName = "sparkExecutor";
    }
}

