/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;

public class TimestampColumnMonthDayMapper
extends AbstractVersionableTimestampColumnMapper<MonthDay> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).toFormatter()).toFormatter();

    public MonthDay fromNonNullString(String s) {
        return MonthDay.parse(s);
    }

    public MonthDay fromNonNullValue(Timestamp value) {
        LocalDateTime ldt = value.toLocalDateTime();
        return MonthDay.of(ldt.getMonth(), ldt.getDayOfMonth());
    }

    public String toNonNullString(MonthDay value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(MonthDay value) {
        LocalDateTime ldt = LocalDateTime.of(1970, value.getMonthValue(), value.getDayOfMonth(), 0, 0);
        Timestamp timestamp = Timestamp.valueOf(ldt);
        return timestamp;
    }
}

