/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.moneta.columnmapper;

import java.math.BigDecimal;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import org.jadira.usertype.moneyandcurrency.moneta.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;
import org.javamoney.moneta.Money;

public class LongColumnMoneyMinorMapper
extends AbstractLongColumnMapper<MonetaryAmount>
implements CurrencyUnitConfigured {
    private static final long serialVersionUID = 4205713919952452881L;
    private CurrencyUnit currencyUnit;

    public Money fromNonNullValue(Long val) {
        BigDecimal minorVal = BigDecimal.valueOf(val, this.currencyUnit.getDefaultFractionDigits());
        return Money.of((BigDecimal)minorVal, (CurrencyUnit)this.currencyUnit);
    }

    public Long toNonNullValue(MonetaryAmount value) {
        if (!this.currencyUnit.equals(value.getCurrency())) {
            throw new IllegalStateException("Expected currency " + this.currencyUnit.getCurrencyCode() + " but was " + value.getCurrency());
        }
        BigDecimal val = (BigDecimal)value.getNumber().numberValue(BigDecimal.class);
        return val.movePointRight(this.currencyUnit.getDefaultFractionDigits()).longValue();
    }

    public Money fromNonNullString(String s) {
        int separator = s.indexOf(32);
        String currency = s.substring(0, separator);
        String value = s.substring(separator + 1);
        return Money.of((Number)Long.parseLong(value), (CurrencyUnit)Monetary.getCurrency((String)currency, (String[])new String[0]));
    }

    public String toNonNullString(MonetaryAmount value) {
        return value.toString();
    }

    @Override
    public void setCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
    }
}

