/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.jadira.usertype.dateandtime.threeten.utils.ZoneHelper;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public class TimestampColumnOffsetTimeMapper
extends AbstractVersionableTimestampColumnMapper<OffsetTime>
implements JavaZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter LOCAL_TIME_PRINTER = new DateTimeFormatterBuilder().appendPattern("0001-01-01 HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).toFormatter();
    public static final DateTimeFormatter LOCAL_TIME_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).toFormatter();
    private static final int MILLIS_IN_SECOND = 1000;
    private ZoneId javaZone = null;

    public TimestampColumnOffsetTimeMapper() {
    }

    public TimestampColumnOffsetTimeMapper(ZoneOffset javaZone) {
        this.javaZone = javaZone;
    }

    public OffsetTime fromNonNullString(String s) {
        return OffsetTime.parse(s);
    }

    public OffsetTime fromNonNullValue(Timestamp value) {
        ZoneId currentJavaZone = this.javaZone == null ? ZoneHelper.getDefaultZoneId() : this.javaZone;
        ZonedDateTime zonedDateTime = value.toInstant().with(ChronoField.NANO_OF_SECOND, value.getNanos()).atZone(currentJavaZone);
        OffsetDateTime dateTime = zonedDateTime.toOffsetDateTime();
        OffsetTime time = dateTime.toOffsetTime();
        return time;
    }

    public String toNonNullString(OffsetTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(OffsetTime value) {
        OffsetDateTime odt = value.atDate(LocalDate.of(1970, 1, 1));
        Timestamp timestamp = new Timestamp(odt.toEpochSecond() * 1000L);
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    public void setJavaZone(ZoneId javaZone) {
        this.javaZone = javaZone;
    }

    public ZoneOffset parseJavaZone(String zoneString) {
        return ZoneOffset.of(zoneString);
    }
}

