/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v1.voice;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.pricing.v1.voice.Number;
import com.twilio.type.PhoneNumber;

public class NumberFetcher
extends Fetcher<Number> {
    private final PhoneNumber pathNumber;

    public NumberFetcher(PhoneNumber pathNumber) {
        this.pathNumber = pathNumber;
    }

    @Override
    public Number fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PRICING.toString(), "/v1/Voice/Numbers/" + this.pathNumber + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Number fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Number.fromJson(response.getStream(), client.getObjectMapper());
    }
}

