/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.google.common.base.Joiner;
import com.google.common.collect.Range;
import com.twilio.exception.ApiException;
import com.twilio.exception.InvalidRequestException;
import com.twilio.http.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class Request {
    public static final String QUERY_STRING_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String QUERY_STRING_DATE_FORMAT = "yyyy-MM-dd";
    private final HttpMethod method;
    private final String url;
    private final Map<String, List<String>> queryParams;
    private final Map<String, List<String>> postParams;
    private String username;
    private String password;

    public Request(HttpMethod method, String url) {
        this.method = method;
        this.url = url;
        this.queryParams = new HashMap<String, List<String>>();
        this.postParams = new HashMap<String, List<String>>();
    }

    public Request(HttpMethod method, String domain, String uri) {
        this(method, domain, uri, null);
    }

    public Request(HttpMethod method, String domain, String uri, String region) {
        this.method = method;
        this.url = "https://" + Joiner.on(".").skipNulls().join(domain, region, "twilio", "com") + uri;
        this.queryParams = new HashMap<String, List<String>>();
        this.postParams = new HashMap<String, List<String>>();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getAuthString() {
        String credentials = this.username + ":" + this.password;
        try {
            String encoded = new Base64().encodeAsString(credentials.getBytes("ascii"));
            return "Basic " + encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("It must be possible to encode credentials as ascii", credentials, e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean requiresAuthentication() {
        return this.username != null || this.password != null;
    }

    public URL constructURL() {
        String params = this.encodeQueryParams();
        String stringUri = this.url;
        if (params.length() > 0) {
            stringUri = stringUri + "?" + params;
        }
        try {
            URI uri = new URI(stringUri);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new ApiException("Bad URI: " + stringUri, e);
        }
        catch (MalformedURLException e) {
            throw new ApiException("Bad URL: " + stringUri, e);
        }
    }

    public void addQueryDateRange(String name, Range<LocalDate> range) {
        String value;
        if (range.hasLowerBound()) {
            value = range.lowerEndpoint().toString(QUERY_STRING_DATE_FORMAT);
            this.addQueryParam(name + ">", value);
        }
        if (range.hasUpperBound()) {
            value = range.upperEndpoint().toString(QUERY_STRING_DATE_FORMAT);
            this.addQueryParam(name + "<", value);
        }
    }

    public void addQueryDateTimeRange(String name, Range<DateTime> range) {
        String value;
        if (range.hasLowerBound()) {
            value = range.lowerEndpoint().toString(QUERY_STRING_DATE_TIME_FORMAT);
            this.addQueryParam(name + ">", value);
        }
        if (range.hasUpperBound()) {
            value = range.upperEndpoint().toString(QUERY_STRING_DATE_TIME_FORMAT);
            this.addQueryParam(name + "<", value);
        }
    }

    public void addQueryParam(String name, String value) {
        this.addParam(this.queryParams, name, value);
    }

    public void addPostParam(String name, String value) {
        this.addParam(this.postParams, name, value);
    }

    private void addParam(Map<String, List<String>> params, String name, String value) {
        if (!params.containsKey(name)) {
            params.put(name, new ArrayList());
        }
        params.get(name).add(value);
    }

    public String encodeFormBody() {
        return Request.encodeParameters(this.postParams);
    }

    public String encodeQueryParams() {
        return Request.encodeParameters(this.queryParams);
    }

    private static String encodeParameters(Map<String, List<String>> params) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            try {
                String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
                for (String value : entry.getValue()) {
                    if (value == null) continue;
                    String encodedValue = URLEncoder.encode(value, "UTF-8");
                    parameters.add(encodedName + "=" + encodedValue);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("Couldn't encode params", entry.getKey(), e);
            }
        }
        return Joiner.on("&").join(parameters);
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, List<String>> getPostParams() {
        return this.postParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request other = (Request)o;
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.url, other.url) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.queryParams, other.queryParams) && Objects.equals(this.postParams, other.postParams);
    }
}

