package models.projects;

import models.*;
import models.contacts.Customer;
import models.contacts.Person;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.db.jpa.Model;
import play.mvc.Router;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by dom on 5/12/2018.
 */
@Entity
public class Lead extends Model implements Event {
    public static final String DD_MM_YYYY = "dd-MM-yyyy";

    public String name;

    public String description;

    public String status; //1 OPENED; 2 REOPENED; 3 FUTURE_EXAMINATION; 4 CLOSED

    @ManyToOne
    public Person handledBy;

    @ManyToOne
    public Customer customer;

    @OneToMany
    public List<Task> tasks = new ArrayList<>();


    @ManyToOne
    public Company company;

    @OneToMany
    public List<Document> attachments = new ArrayList<>();

    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime createDate;

    @ManyToOne
    public AppUser uploader;

//    public enum LeadStatus {
//        OPEN,
//        REOPENED,
//        FUTURE_EXAMINATION,
//        CLOSED
//    }

    public Lead() {

    }

    public Lead(AppUser handledBy, Customer customer, String description, DateTime createDate, AppUser uploader) {
        this.handledBy = handledBy;
        this.customer = customer;
        this.description = description;
        this.createDate = createDate;
        this.uploader = uploader;
    }

    public String getcreatedDateString() {
        if (this.createDate == null) {
            return "";
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern(DD_MM_YYYY);
        return fmt.print(createDate);
    }

    public long getNumberOfActiveTasks()
    {
        return  this.tasks.stream().filter(t -> t.status.equals("0")).count();
    }

    @Override
    public DateTime getStartDate() {
        return createDate;
    }

    @Override
    public String getTitle() {
        return name;
    }

    @Override
    public String getCalendarContent() {
        return null;
    }

    @Override
    public String getUrl() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        return Router.getFullUrl("Projects.addLead", map);
    }

    @Override
    public String getUploadedBy() {
        return uploader.userName;
    }

    @Override
    public JSONEvent getEvent() {
        JSONEvent event = new JSONEvent(getStartDate().toDate(), "Lead: " + getTitle(), getCalendarContent(), "#00acac", this.getUrl(), this.getUploadedBy(), this.getClass());
        return event;
    }
}
