package controllers;

import flexjson.JSONSerializer;
import models.AppUser;
import models.Document;
import models.Share;
import models.chat.Message;
import models.chat.MessageRead;
import models.contacts.Person;
import org.joda.time.DateTime;
import play.Logger;
import play.mvc.Controller;

import java.util.List;

/**
 * Created by dom on 29/1/2019.
 */
public class Documents  extends Controller {

    public static void getDocumentDetails(Long documentID) {

        try {
            Document doc = Document.findById(documentID);
            JSONSerializer serializer;
            serializer = new JSONSerializer()
                    .include("*.id.*")
                    .include("*.dbfile.title.*")
                    .include("*.description.*")
                    .include("*.iscoverphoto.*")
                    .exclude("*");

            Logger.info("doc  " +doc.id);
            renderJSON(serializer.serialize(doc));
        } catch (Exception ex) {
            Logger.info("ERROR getPersonDetails " + ex);
            renderJSON(0);
        }
    }

    public static void doUpdateDocument(Long documentID, String title, String description)
    {
        Document doc = Document.findById(documentID);
        doc.dbfile.title = title;
        doc.description = description;
        doc.save();
        doc.dbfile.save();
    }

    public static void listMessages(Long documentID)
    {
        AppUser user = AppUser.find("byUsername", Security.connected()).first();
        Document doc = Document.findById(documentID);
        List<Message> msges = Message.find("select m from Message m where m.document =:doc").setParameter("doc", doc).fetch();

        Logger.info("posa msg " +msges.size());

        renderTemplate("app/views/Application/listMessages.html", msges, user);
    }

    public static void doAddMessage(Long messageId, Long documentId, String content)
    {
        Logger.info("----- " +messageId);
        Logger.info("----- " +documentId);
        Logger.info("----- " +content);
        AppUser user = AppUser.find("byUsername", Security.connected()).first();
        Logger.info("--rrrr--- " +user.userName);
        Message message = null;
        Document doc = Document.findById(documentId);

        Message msg = new Message();
        msg.msgContent = content;
        msg.msgSender = user;
        msg.document = doc;
        msg.sendDate = DateTime.now();
        msg.save();

        //add to message-read for the user that posted it
        MessageRead mread = new MessageRead();
        mread.contact = user;
        mread.message = msg;
        mread.isRead = true;
        mread.save();

        //TODO must also add the message to read for users that are actively in the same chatbox atm of insert???????
        renderJSON(1);
    }




//    public static void shareWith(Long fileId, Long personId)
//    {
//        Document doc = Document.findById(fileId);
//        Person usr = Person.findById(personId);
//
//        //Logger.info("------- " +usr.userName + "----------- " +doc.title);
//        usr.sharedDocuments.add(doc);
//        usr.save();
//
//        Logger.info("********* " +usr.sharedDocuments.size());
//    }



}
