/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.unitsofmeasurement.indriya;

import java.util.ArrayList;
import javax.measure.Unit;
import org.hibernate.SessionFactory;
import org.jadira.usertype.spi.shared.AbstractParameterizedUserType;
import org.jadira.usertype.spi.shared.ValidTypesConfigured;
import org.jadira.usertype.spi.utils.reflection.ClassLoaderUtils;
import org.jadira.usertype.unitsofmeasurement.indriya.columnmapper.StringColumnUnitMapper;

public class PersistentUnit
extends AbstractParameterizedUserType<Unit<?>, String, StringColumnUnitMapper> {
    private static final long serialVersionUID = -2015829087239519037L;

    public void applyConfiguration(SessionFactory sessionFactory) {
        super.applyConfiguration(sessionFactory);
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        ValidTypesConfigured next = (ValidTypesConfigured)this.getColumnMapper();
        this.performValidTypesConfiguration(next);
    }

    private void performValidTypesConfiguration(ValidTypesConfigured<Unit<?>> next) {
        String validTypesString = null;
        if (this.getParameterValues() != null) {
            validTypesString = this.getParameterValues().getProperty("validTypes");
        }
        if (validTypesString != null) {
            String[] validTypes = validTypesString.split(",");
            ArrayList<Class> units = new ArrayList<Class>();
            for (String nextType : validTypes) {
                try {
                    Class nextClass = ClassLoaderUtils.classForName((String)nextType);
                    units.add(nextClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot find specified class " + nextType, e);
                }
            }
            next.setValidTypes(units);
        }
    }
}

