/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.moneta;

import java.math.BigDecimal;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import org.jadira.usertype.moneyandcurrency.legacyjdk.columnmapper.LongLongColumnMapper;
import org.jadira.usertype.moneyandcurrency.moneta.columnmapper.StringColumnCurrencyUnitMapper;
import org.jadira.usertype.spi.shared.AbstractMultiColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.javamoney.moneta.FastMoney;

public class PersistentFastMoneyMinorAmountAndCurrency
extends AbstractMultiColumnUserType<MonetaryAmount> {
    private static final long serialVersionUID = -3990523657883978202L;
    private static final ColumnMapper<?, ?>[] COLUMN_MAPPERS = new ColumnMapper[]{new StringColumnCurrencyUnitMapper(), new LongLongColumnMapper()};
    private static final String[] PROPERTY_NAMES = new String[]{"currencyUnit", "amountMinor"};

    protected ColumnMapper<?, ?>[] getColumnMappers() {
        return COLUMN_MAPPERS;
    }

    protected FastMoney fromConvertedColumns(Object[] convertedColumns) {
        CurrencyUnit currencyUnitPart = (CurrencyUnit)convertedColumns[0];
        Long amountMinorPart = (Long)convertedColumns[1];
        BigDecimal majorVal = BigDecimal.valueOf(amountMinorPart, currencyUnitPart.getDefaultFractionDigits());
        return FastMoney.of((Number)majorVal, (CurrencyUnit)currencyUnitPart);
    }

    protected Object[] toConvertedColumns(MonetaryAmount value) {
        BigDecimal minorVal = (BigDecimal)value.getNumber().numberValue(BigDecimal.class);
        minorVal = minorVal.movePointRight(value.getCurrency().getDefaultFractionDigits());
        return new Object[]{value.getCurrency(), minorVal.longValue()};
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

