/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.time.LocalTime;
import org.jadira.usertype.spi.shared.AbstractIntegerColumnMapper;

public class IntegerColumnLocalTimeMapper
extends AbstractIntegerColumnMapper<LocalTime> {
    private static final long serialVersionUID = -3448788221055335510L;

    public LocalTime fromNonNullString(String s) {
        return LocalTime.parse(s);
    }

    public LocalTime fromNonNullValue(Integer value) {
        long nanos = (long)value.intValue() * 1000000L;
        return LocalTime.ofNanoOfDay(nanos);
    }

    public String toNonNullString(LocalTime value) {
        return value.toString();
    }

    public Integer toNonNullValue(LocalTime value) {
        Integer integer = (int)(value.toNanoOfDay() / 1000000L);
        return integer;
    }
}

