/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.wireless.CommandCreator;
import com.twilio.rest.preview.wireless.CommandFetcher;
import com.twilio.rest.preview.wireless.CommandReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Command
extends Resource {
    private static final long serialVersionUID = 102379842720145L;
    private final String sid;
    private final String accountSid;
    private final String deviceSid;
    private final String simSid;
    private final String command;
    private final String commandMode;
    private final String status;
    private final String direction;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static CommandFetcher fetcher(String pathSid) {
        return new CommandFetcher(pathSid);
    }

    public static CommandReader reader() {
        return new CommandReader();
    }

    public static CommandCreator creator(String command) {
        return new CommandCreator(command);
    }

    public static Command fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Command.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Command fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Command.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Command(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="device_sid") String deviceSid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="command") String command, @JsonProperty(value="command_mode") String commandMode, @JsonProperty(value="status") String status, @JsonProperty(value="direction") String direction, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.deviceSid = deviceSid;
        this.simSid = simSid;
        this.command = command;
        this.commandMode = commandMode;
        this.status = status;
        this.direction = direction;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDeviceSid() {
        return this.deviceSid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getCommand() {
        return this.command;
    }

    public final String getCommandMode() {
        return this.commandMode;
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getDirection() {
        return this.direction;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command other = (Command)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.deviceSid, other.deviceSid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.command, other.command) && Objects.equals(this.commandMode, other.commandMode) && Objects.equals(this.status, other.status) && Objects.equals(this.direction, other.direction) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.deviceSid, this.simSid, this.command, this.commandMode, this.status, this.direction, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("deviceSid", this.deviceSid).add("simSid", this.simSid).add("command", this.command).add("commandMode", this.commandMode).add("status", this.status).add("direction", this.direction).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }
}

