/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.document;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.document.DocumentPermission;

public class DocumentPermissionReader
extends Reader<DocumentPermission> {
    private final String pathServiceSid;
    private final String pathDocumentSid;

    public DocumentPermissionReader(String pathServiceSid, String pathDocumentSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathDocumentSid = pathDocumentSid;
    }

    @Override
    public ResourceSet<DocumentPermission> read(TwilioRestClient client) {
        return new ResourceSet<DocumentPermission>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DocumentPermission> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Documents/" + this.pathDocumentSid + "/Permissions", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DocumentPermission> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DocumentPermission> nextPage(Page<DocumentPermission> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DocumentPermission> previousPage(Page<DocumentPermission> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<DocumentPermission> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DocumentPermission read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("permissions", response.getContent(), DocumentPermission.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

