/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Time;
import java.util.Calendar;
import org.jadira.usertype.spi.shared.AbstractTimeColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimeType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.TimeOfDay;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class TimeColumnTimeOfDayMapper
extends AbstractTimeColumnMapper<TimeOfDay>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = 6734385103313158326L;
    private DateTimeZone databaseZone = null;
    public static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();

    public TimeColumnTimeOfDayMapper() {
    }

    public TimeColumnTimeOfDayMapper(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public TimeOfDay fromNonNullString(String s) {
        return new TimeOfDay((Object)s);
    }

    public TimeOfDay fromNonNullValue(Time value) {
        DateTime dateTime = new DateTime(value.getTime());
        LocalTime localTime = dateTime.toLocalTime();
        TimeOfDay timeOfDay = new TimeOfDay(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond(), localTime.getChronology());
        return timeOfDay;
    }

    public String toNonNullString(TimeOfDay value) {
        return value.toString();
    }

    public Time toNonNullValue(TimeOfDay value) {
        DateTime zonedValue = new LocalDateTime(1970, 1, 1, value.getHourOfDay(), value.getMinuteOfHour(), value.getSecondOfMinute(), value.getMillisOfSecond(), value.getChronology()).toDateTime();
        Time time = new Time(zonedValue.getMillis());
        return time;
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }

    public final DstSafeTimeType getHibernateType() {
        return this.databaseZone == null ? DstSafeTimeType.INSTANCE : new DstSafeTimeType(Calendar.getInstance(this.databaseZone.toTimeZone()));
    }
}

