/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Date;
import java.util.Calendar;
import org.jadira.usertype.spi.shared.AbstractDateColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeDateType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateColumnYearMonthDayMapper
extends AbstractDateColumnMapper<YearMonthDay>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = 5399269707841091964L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();
    private DateTimeZone databaseZone = null;

    public DateColumnYearMonthDayMapper() {
    }

    public DateColumnYearMonthDayMapper(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public YearMonthDay fromNonNullString(String s) {
        return new YearMonthDay((Object)s);
    }

    public YearMonthDay fromNonNullValue(Date value) {
        if (this.databaseZone == null) {
            return new YearMonthDay((Object)value.toString());
        }
        DateTime dateTime = new DateTime(value.getTime());
        YearMonthDay localDate = dateTime.toYearMonthDay();
        return localDate;
    }

    public String toNonNullString(YearMonthDay value) {
        return value.toString();
    }

    public Date toNonNullValue(YearMonthDay value) {
        if (this.databaseZone == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.print((ReadablePartial)value.toLocalDate()));
        }
        DateTime zonedValue = value.toDateTime((ReadableInstant)value.toLocalDate().toDateTimeAtStartOfDay());
        Date date = new Date(zonedValue.getMillis());
        return date;
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }

    public final DstSafeDateType getHibernateType() {
        return this.databaseZone == null ? DstSafeDateType.INSTANCE : new DstSafeDateType(Calendar.getInstance(this.databaseZone.toTimeZone()));
    }
}

