/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.unitsofmeasurement.indriya;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import org.hibernate.SessionFactory;
import org.jadira.usertype.spi.shared.AbstractParameterizedMultiColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.ValidTypesConfigured;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;
import org.jadira.usertype.spi.utils.reflection.ClassLoaderUtils;
import org.jadira.usertype.unitsofmeasurement.indriya.columnmapper.StringColumnStringMapper;
import org.jadira.usertype.unitsofmeasurement.indriya.columnmapper.StringColumnUnitMapper;
import tec.units.indriya.quantity.Quantities;
import tec.units.indriya.unit.Units;

public class PersistentQuantityAndUnit
extends AbstractParameterizedMultiColumnUserType<Quantity<?>>
implements ValidTypesConfigured<Unit<?>> {
    private static final long serialVersionUID = -2015829087239519037L;
    private static final SystemOfUnits UNITS = Units.getInstance();
    private final Map<String, Unit<?>> unitsMap = new HashMap();
    private List<Class<Unit<?>>> validTypes;
    private static final ColumnMapper<?, ?>[] COLUMN_MAPPERS = new ColumnMapper[]{new StringColumnStringMapper(), new StringColumnUnitMapper()};
    private static final String[] PROPERTY_NAMES = new String[]{"quantity", "unit"};

    public PersistentQuantityAndUnit() {
        for (Unit next : UNITS.getUnits()) {
            this.unitsMap.put(next.getSymbol(), next);
        }
    }

    public void applyConfiguration(SessionFactory sessionFactory) {
        super.applyConfiguration(sessionFactory);
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        PersistentQuantityAndUnit next = this;
        this.performValidTypesConfiguration(next);
    }

    private void performValidTypesConfiguration(ValidTypesConfigured<Unit<?>> next) {
        String validTypesString = null;
        if (this.getParameterValues() != null) {
            validTypesString = this.getParameterValues().getProperty("validTypes");
        }
        if (validTypesString != null) {
            String[] validTypes = validTypesString.split(",");
            ArrayList<Class> units = new ArrayList<Class>();
            for (String nextType : validTypes) {
                try {
                    Class nextClass = ClassLoaderUtils.classForName((String)nextType);
                    units.add(nextClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot find specified class " + nextType, e);
                }
            }
            next.setValidTypes(units);
        }
    }

    public void setValidTypes(List<Class<Unit<?>>> types) {
        for (Class<Unit<?>> next : types) {
            Unit<?> unit;
            try {
                unit = next.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Cannot instantiate " + next.getName() + ": " + e.getMessage(), e);
            }
            this.unitsMap.put(unit.getSymbol(), unit);
        }
        this.validTypes = Collections.unmodifiableList(types);
    }

    public List<Class<Unit<?>>> getValidTypes() {
        return this.validTypes;
    }

    protected Quantity<?> fromConvertedColumns(Object[] convertedColumns) {
        String stringPart = (String)convertedColumns[0];
        Unit unit = (Unit)convertedColumns[1];
        return Quantities.getQuantity((CharSequence)(stringPart + " " + unit.getSymbol()));
    }

    protected Object[] toConvertedColumns(Quantity<?> value) {
        return new Object[]{value.getValue().toString(), value.getUnit()};
    }

    protected ColumnMapper<?, ?>[] getColumnMappers() {
        return COLUMN_MAPPERS;
    }

    public String[] getPropertyNames() {
        return (String[])ArrayUtils.copyOf((Object[])PROPERTY_NAMES);
    }
}

