/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.random;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.AcceptanceResult;
import org.apache.spark.util.random.AcceptanceResult$;
import org.apache.spark.util.random.BinomialBounds$;
import org.apache.spark.util.random.PoissonBounds$;
import org.apache.spark.util.random.StratifiedSamplingUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ResizableArray;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class StratifiedSamplingUtils$
implements Logging {
    public static StratifiedSamplingUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StratifiedSamplingUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <K, V> scala.collection.mutable.Map<K, AcceptanceResult> getAcceptanceResults(RDD<Tuple2<K, V>> rdd, boolean withReplacement, Map<K, Object> fractions, Option<Map<K, Object>> counts, long seed) {
        Function2 combOp = this.getCombOp();
        RDD mappedPartitionRDD = rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> StratifiedSamplingUtils$.$anonfun$getAcceptanceResults$1(withReplacement, fractions, counts, seed, combOp, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class));
        return mappedPartitionRDD.reduce(combOp);
    }

    public <K, V> Function2<scala.collection.mutable.Map<K, AcceptanceResult>, Tuple2<K, V>, scala.collection.mutable.Map<K, AcceptanceResult>> getSeqOp(boolean withReplacement, Map<K, Object> fractions, StratifiedSamplingUtils.RandomDataGenerator rng, Option<Map<K, Object>> counts) {
        double delta = 5.0E-5;
        return (Function2 & Serializable & scala.Serializable)(result, item) -> {
            Object object;
            Object key = item._1();
            double fraction = BoxesRunTime.unboxToDouble((Object)fractions.apply(key));
            Object object2 = !result.contains(key) ? result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)new AcceptanceResult(AcceptanceResult$.MODULE$.$lessinit$greater$default$1(), AcceptanceResult$.MODULE$.$lessinit$greater$default$2()))) : BoxedUnit.UNIT;
            AcceptanceResult acceptResult = (AcceptanceResult)result.apply(key);
            if (withReplacement) {
                int copiesWaitlisted;
                double acceptBound;
                long copiesAccepted;
                if (acceptResult.areBoundsEmpty()) {
                    long n = BoxesRunTime.unboxToLong((Object)((MapLike)counts.get()).apply(key));
                    long sampleSize = (long)scala.math.package$.MODULE$.ceil((double)n * fraction);
                    double lmbd1 = PoissonBounds$.MODULE$.getLowerBound(sampleSize);
                    double lmbd2 = PoissonBounds$.MODULE$.getUpperBound(sampleSize);
                    acceptResult.acceptBound_$eq(lmbd1 / (double)n);
                    acceptResult.waitListBound_$eq((lmbd2 - lmbd1) / (double)n);
                }
                long l = copiesAccepted = (acceptBound = acceptResult.acceptBound()) == 0.0 ? 0L : (long)rng.nextPoisson(acceptBound);
                if (copiesAccepted > 0L) {
                    acceptResult.numAccepted_$eq(acceptResult.numAccepted() + copiesAccepted);
                }
                object = (copiesWaitlisted = rng.nextPoisson(acceptResult.waitListBound())) > 0 ? acceptResult.waitList().$plus$plus$eq((TraversableOnce)ArrayBuffer$.MODULE$.fill(copiesWaitlisted, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextUniform())) : BoxedUnit.UNIT;
            } else {
                acceptResult.acceptBound_$eq(BinomialBounds$.MODULE$.getLowerBound(delta, acceptResult.numItems(), fraction));
                acceptResult.waitListBound_$eq(BinomialBounds$.MODULE$.getUpperBound(delta, acceptResult.numItems(), fraction));
                double x = rng.nextUniform();
                if (x < acceptResult.acceptBound()) {
                    acceptResult.numAccepted_$eq(acceptResult.numAccepted() + 1L);
                    object = BoxedUnit.UNIT;
                } else {
                    object = x < acceptResult.waitListBound() ? acceptResult.waitList().$plus$eq((Object)BoxesRunTime.boxToDouble((double)x)) : BoxedUnit.UNIT;
                }
            }
            acceptResult.numItems_$eq(acceptResult.numItems() + 1L);
            return result;
        };
    }

    public <K> Function2<scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>> getCombOp() {
        return (Function2 & Serializable & scala.Serializable)(result1, result2) -> {
            result1.keySet().union((GenSet)result2.keySet()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                Object object;
                Option entry1 = result1.get(key);
                if (result2.contains(key)) {
                    ((AcceptanceResult)result2.apply(key)).merge((Option<AcceptanceResult>)entry1);
                    object = BoxedUnit.UNIT;
                } else {
                    object = entry1.isDefined() ? result2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), entry1.get())) : BoxedUnit.UNIT;
                }
                return object;
            });
            return result2;
        };
    }

    /*
     * WARNING - void declaration
     */
    public <K> Map<K, Object> computeThresholdByKey(Map<K, AcceptanceResult> finalResult, Map<K, Object> fractions) {
        void var3_3;
        HashMap thresholdByKey = new HashMap();
        finalResult.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StratifiedSamplingUtils$.$anonfun$computeThresholdByKey$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            HashMap hashMap;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                AcceptanceResult acceptResult = (AcceptanceResult)tuple2._2();
                long sampleSize = (long)scala.math.package$.MODULE$.ceil((double)acceptResult.numItems() * BoxesRunTime.unboxToDouble((Object)fractions.apply(key)));
                if (acceptResult.numAccepted() > sampleSize) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Pre-accepted too many");
                    hashMap = thresholdByKey.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToDouble((double)acceptResult.acceptBound())));
                } else {
                    int numWaitListAccepted = (int)(sampleSize - acceptResult.numAccepted());
                    if (numWaitListAccepted >= acceptResult.waitList().size()) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "WaitList too short");
                        hashMap = thresholdByKey.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToDouble((double)acceptResult.waitListBound())));
                    } else {
                        hashMap = thresholdByKey.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), ((ResizableArray)acceptResult.waitList().sorted((Ordering)Ordering.Double$.MODULE$)).apply(numWaitListAccepted)));
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            HashMap hashMap2 = hashMap;
            return hashMap2;
        });
        return var3_3;
    }

    public <K, V> Function2<Object, Iterator<Tuple2<K, V>>, Iterator<Tuple2<K, V>>> getBernoulliSamplingFunction(RDD<Tuple2<K, V>> rdd, Map<K, Object> fractions, boolean exact, long seed) {
        ObjectRef samplingRateByKey;
        block0: {
            samplingRateByKey = ObjectRef.create(fractions);
            if (!exact) break block0;
            scala.collection.mutable.Map<K, AcceptanceResult> finalResult = this.getAcceptanceResults(rdd, false, fractions, (Option<Map<K, Object>>)None$.MODULE$, seed);
            samplingRateByKey.elem = this.computeThresholdByKey((Map<K, AcceptanceResult>)finalResult, fractions);
        }
        return (Function2 & Serializable & scala.Serializable)(idx, iter) -> StratifiedSamplingUtils$.$anonfun$getBernoulliSamplingFunction$1(seed, samplingRateByKey, BoxesRunTime.unboxToInt((Object)idx), iter);
    }

    public <K, V> Function2<Object, Iterator<Tuple2<K, V>>, Iterator<Tuple2<K, V>>> getPoissonSamplingFunction(RDD<Tuple2<K, V>> rdd, Map<K, Object> fractions, boolean exact, long seed, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        Function2 & Serializable & scala.Serializable intersect;
        if (exact) {
            RDD<Tuple2<K, V>> x$2 = rdd;
            ClassTag<K> x$3 = evidence$1;
            ClassTag<V> x$4 = evidence$2;
            Null$ x$5 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$2);
            Some counts = new Some(RDD$.MODULE$.rddToPairRDDFunctions(x$2, x$3, x$4, null).countByKey());
            scala.collection.mutable.Map finalResult = this.getAcceptanceResults(rdd, true, fractions, (Option<Map<K, Object>>)counts, seed);
            Map thresholdByKey = this.computeThresholdByKey((Map<K, AcceptanceResult>)finalResult, fractions);
            intersect = (Function2 & Serializable & scala.Serializable)(idx, iter) -> StratifiedSamplingUtils$.$anonfun$getPoissonSamplingFunction$1(seed, finalResult, thresholdByKey, BoxesRunTime.unboxToInt((Object)idx), iter);
        } else {
            intersect = (Function2 & Serializable & scala.Serializable)(idx, iter) -> StratifiedSamplingUtils$.$anonfun$getPoissonSamplingFunction$5(fractions, seed, BoxesRunTime.unboxToInt((Object)idx), iter);
        }
        return intersect;
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$getAcceptanceResults$2(scala.collection.mutable.Map zeroU$1) {
        return zeroU$1;
    }

    public static final /* synthetic */ Iterator $anonfun$getAcceptanceResults$1(boolean withReplacement$1, Map fractions$2, Option counts$1, long seed$3, Function2 combOp$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int partition = tuple2._1$mcI$sp();
        Iterator iter = (Iterator)tuple2._2();
        HashMap zeroU = new HashMap();
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$3 + (long)partition);
        Function2 seqOp = MODULE$.getSeqOp(withReplacement$1, fractions$2, rng, counts$1);
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.mutable.Map[]{(scala.collection.mutable.Map)iter.aggregate(() -> StratifiedSamplingUtils$.$anonfun$getAcceptanceResults$2((scala.collection.mutable.Map)zeroU), seqOp, combOp$1)}));
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$computeThresholdByKey$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getBernoulliSamplingFunction$2(ObjectRef samplingRateByKey$1, StratifiedSamplingUtils.RandomDataGenerator rng$2, Tuple2 t) {
        return rng$2.nextUniform() < BoxesRunTime.unboxToDouble((Object)((Map)samplingRateByKey$1.elem).apply(t._1()));
    }

    public static final /* synthetic */ Iterator $anonfun$getBernoulliSamplingFunction$1(long seed$2, ObjectRef samplingRateByKey$1, int idx, Iterator iter) {
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$2 + (long)idx);
        return iter.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)StratifiedSamplingUtils$.$anonfun$getBernoulliSamplingFunction$2(samplingRateByKey$1, rng, t)));
    }

    public static final /* synthetic */ Iterator $anonfun$getPoissonSamplingFunction$1(long seed$1, scala.collection.mutable.Map finalResult$1, Map thresholdByKey$2, int idx, Iterator iter) {
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$1 + (long)idx);
        return iter.flatMap((Function1 & Serializable & scala.Serializable)item -> {
            Object key = item._1();
            double acceptBound = ((AcceptanceResult)finalResult$1.apply(key)).acceptBound();
            long copiesAccepted = acceptBound == 0.0 ? 0L : (long)rng.nextPoisson(acceptBound);
            int copiesWaitlisted = rng.nextPoisson(((AcceptanceResult)finalResult$1.apply(key)).waitListBound());
            long copiesInSample = copiesAccepted + (long)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), copiesWaitlisted).count((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> rng.nextUniform() < BoxesRunTime.unboxToDouble((Object)thresholdByKey$2.apply(key)));
            return copiesInSample > 0L ? package$.MODULE$.Iterator().fill((int)copiesInSample, (Function0 & Serializable & scala.Serializable)() -> item) : package$.MODULE$.Iterator().empty();
        });
    }

    public static final /* synthetic */ Iterator $anonfun$getPoissonSamplingFunction$5(Map fractions$1, long seed$1, int idx, Iterator iter) {
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$1 + (long)idx);
        return iter.flatMap((Function1 & Serializable & scala.Serializable)item -> {
            int count = rng.nextPoisson(BoxesRunTime.unboxToDouble((Object)fractions$1.apply(item._1())));
            return count == 0 ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().fill(count, (Function0 & Serializable & scala.Serializable)() -> item);
        });
    }

    private StratifiedSamplingUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

