/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\u0001\u0003\u0001\u0011Q!\u0001\u0005#jg.\u0014En\\2l\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\tS:$XM\u001d8bY&\u0011ac\u0005\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!A!\u0002\u0013Q\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005\tB-\u001a7fi\u00164\u0015\u000e\\3t\u001f:\u001cFo\u001c9\u0011\u00051\t\u0013B\u0001\u0012\u000e\u0005\u001d\u0011un\u001c7fC:DQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtDc\u0001\u0014)SA\u0011q\u0005A\u0007\u0002\u0005!)\u0001d\ta\u00015!)qd\ta\u0001A!A1\u0006\u0001b\u0001\n\u0003!A&\u0001\ntk\n$\u0015N]:QKJdunY1m\t&\u0014X#A\u0017\u0011\u00051q\u0013BA\u0018\u000e\u0005\rIe\u000e\u001e\u0005\u0007c\u0001\u0001\u000b\u0011B\u0017\u0002'M,(\rR5sgB+'\u000fT8dC2$\u0015N\u001d\u0011\t\u0011M\u0002!\u0019!C\u0001\tQ\n\u0011\u0002\\8dC2$\u0015N]:\u0016\u0003U\u00022\u0001\u0004\u001c9\u0013\t9TBA\u0003BeJ\f\u0017\u0010\u0005\u0002:}5\t!H\u0003\u0002<y\u0005\u0011\u0011n\u001c\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0003GS2,\u0007BB!\u0001A\u0003%Q'\u0001\u0006m_\u000e\fG\u000eR5sg\u0002Bqa\u0011\u0001C\u0002\u0013%A)A\u0004tk\n$\u0015N]:\u0016\u0003\u0015\u00032\u0001\u0004\u001c6\u0011\u00199\u0005\u0001)A\u0005\u000b\u0006A1/\u001e2ESJ\u001c\b\u0005C\u0004J\u0001\t\u0007I\u0011\u0002&\u0002\u0019MDW\u000f\u001e3po:Dun\\6\u0016\u0003-Aa\u0001\u0014\u0001!\u0002\u0013Y\u0011!D:ikR$wn\u001e8I_>\\\u0007\u0005C\u0003O\u0001\u0011\u0005q*A\u0004hKR4\u0015\u000e\\3\u0015\u0005a\u0002\u0006\"B)N\u0001\u0004\u0011\u0016\u0001\u00034jY\u0016t\u0017-\\3\u0011\u0005MSfB\u0001+Y!\t)V\"D\u0001W\u0015\t9\u0016$\u0001\u0004=e>|GOP\u0005\u000336\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011,\u0004\u0005\u0006\u001d\u0002!\tA\u0018\u000b\u0003q}CQ\u0001Y/A\u0002\u0005\fqA\u00197pG.LE\r\u0005\u0002(E&\u00111M\u0001\u0002\b\u00052|7m[%e\u0011\u0015)\u0007\u0001\"\u0001g\u00035\u0019wN\u001c;bS:\u001c(\t\\8dWR\u0011\u0001e\u001a\u0005\u0006A\u0012\u0004\r!\u0019\u0005\u0006S\u0002!\tA[\u0001\fO\u0016$\u0018\t\u001c7GS2,7\u000fF\u0001l!\ra\u0017\u000f\u000f\b\u0003[>t!!\u00168\n\u00039I!\u0001]\u0007\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0004'\u0016\f(B\u00019\u000e\u0011\u0015)\b\u0001\"\u0001w\u000319W\r^!mY\ncwnY6t)\u00059\bc\u00017rC\")\u0011\u0010\u0001C\u0001u\u0006!2M]3bi\u0016$V-\u001c9M_\u000e\fGN\u00117pG.$\u0012a\u001f\t\u0005\u0019qt\b(\u0003\u0002~\u001b\t1A+\u001e9mKJ\u0002\"aJ@\n\u0007\u0005\u0005!A\u0001\tUK6\u0004Hj\\2bY\ncwnY6JI\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011AF2sK\u0006$X\rV3naNCWO\u001a4mK\ncwnY6\u0015\u0005\u0005%\u0001#\u0002\u0007}\u0003\u0017A\u0004cA\u0014\u0002\u000e%\u0019\u0011q\u0002\u0002\u0003%Q+W\u000e]*ik\u001a4G.\u001a\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003'\u0001A\u0011BA\u000b\u0003=\u0019'/Z1uK2{7-\u00197ESJ\u001cHcA\u001b\u0002\u0018!1\u0001$!\u0005A\u0002iAq!a\u0007\u0001\t\u0013\ti\"A\bbI\u0012\u001c\u0006.\u001e;e_^t\u0007j\\8l)\u0005Y\u0001\u0002CA\u0011\u0001\u0011\u0005A!a\t\u0002\tM$x\u000e\u001d\u000b\u0003\u0003K\u00012\u0001DA\u0014\u0013\r\tI#\u0004\u0002\u0005+:LG\u000fC\u0004\u0002.\u0001!I!a\t\u0002\r\u0011|7\u000b^8q\u0001")
public class DiskBlockManager
implements Logging {
    private final boolean deleteFilesOnStop;
    private final int subDirsPerLocalDir;
    private final File[] localDirs;
    private final File[][] subDirs;
    private final Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    public File[] localDirs() {
        return this.localDirs;
    }

    private File[][] subDirs() {
        return this.subDirs;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                File newDir = new File(this.localDirs()[dirId], new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                if (!newDir.exists() && !newDir.mkdir()) {
                    throw new IOException(new StringBuilder(31).append("Failed to create local dir in ").append(newDir).append(".").toString());
                }
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public File getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    public boolean containsBlock(BlockId blockId) {
        return this.getFile(blockId.name()).exists();
    }

    public Seq<File> getAllFiles() {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.subDirs())).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(DiskBlockManager.$anonfun$getAllFiles$1(dir)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getAllFiles$2(x$1))))).flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File[] files = dir.listFiles();
            return files != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)) : (SeqLike)Seq$.MODULE$.empty();
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<BlockId> getAllBlocks() {
        return (Seq)this.getAllFiles().flatMap((Function1 & Serializable & scala.Serializable)f -> {
            Iterable iterable;
            try {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BlockId$.MODULE$.apply(f.getName())));
            }
            catch (UnrecognizedBlockId unrecognizedBlockId) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<TempLocalBlockId, File> createTempLocalBlock() {
        TempLocalBlockId blockId = new TempLocalBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempLocalBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    public Tuple2<TempShuffleBlockId, File> createTempShuffleBlock() {
        TempShuffleBlockId blockId = new TempShuffleBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempShuffleBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    private File[] createLocalDirs(SparkConf conf) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf))).flatMap((Function1 & Serializable & scala.Serializable)rootDir -> {
            Iterable iterable;
            try {
                File localDir = Utils$.MODULE$.createDirectory((String)rootDir, "blockmgr");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Created local directory at ").append(localDir).toString());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)localDir));
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to create local dir in ").append((String)rootDir).append(". Ignoring this directory.").toString(), e);
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while removing shutdown hook.", e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        block0: {
            if (!this.deleteFilesOnStop) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).foreach((Function1 & Serializable & scala.Serializable)localDir -> {
                DiskBlockManager.$anonfun$doStop$1(this, localDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ Object[] $anonfun$getAllFiles$1(File[] dir) {
        File[] fileArray = dir;
        synchronized (dir) {
            File[] fileArray2 = (File[])dir.clone();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Predef$.MODULE$.refArrayOps((Object[])fileArray2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllFiles$2(File x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ void $anonfun$doStop$1(DiskBlockManager $this, File localDir) {
        block3: {
            if (!localDir.isDirectory() || !localDir.exists()) break block3;
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Exception while deleting local spark dir: ").append(localDir).toString(), e);
            }
        }
    }

    public DiskBlockManager(SparkConf conf, boolean deleteFilesOnStop) {
        this.deleteFilesOnStop = deleteFilesOnStop;
        Logging.$init$(this);
        this.subDirsPerLocalDir = conf.getInt("spark.diskStore.subDirectories", 64);
        this.localDirs = this.createLocalDirs(conf);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).isEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.subDirs = (File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable & scala.Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class)));
        this.shutdownHook = this.addShutdownHook();
    }
}

