/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.util.ByteBufferInputStream;
import org.apache.spark.util.ByteBufferOutputStream;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TaskDescription$ {
    public static TaskDescription$ MODULE$;

    static {
        new TaskDescription$();
    }

    private void serializeStringLongMap(Map<String, Object> map, DataOutputStream dataOut) {
        dataOut.writeInt(map.size());
        map.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TaskDescription$.$anonfun$serializeStringLongMap$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            TaskDescription$.$anonfun$serializeStringLongMap$2(dataOut, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public ByteBuffer encode(TaskDescription taskDescription) {
        ByteBufferOutputStream bytesOut = new ByteBufferOutputStream(4096);
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        dataOut.writeLong(taskDescription.taskId());
        dataOut.writeInt(taskDescription.attemptNumber());
        dataOut.writeUTF(taskDescription.executorId());
        dataOut.writeUTF(taskDescription.name());
        dataOut.writeInt(taskDescription.index());
        dataOut.writeInt(taskDescription.partitionId());
        this.serializeStringLongMap(taskDescription.addedFiles(), dataOut);
        this.serializeStringLongMap(taskDescription.addedJars(), dataOut);
        dataOut.writeInt(taskDescription.properties().size());
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(taskDescription.properties()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TaskDescription$.$anonfun$encode$1(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
        Utils$.MODULE$.writeByteBuffer(taskDescription.serializedTask(), bytesOut);
        dataOut.close();
        bytesOut.close();
        return bytesOut.toByteBuffer();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> deserializeStringLongMap(DataInputStream dataIn) {
        void var2_2;
        HashMap map = new HashMap();
        int mapSize = dataIn.readInt();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mapSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> map.update((Object)dataIn.readUTF(), (Object)BoxesRunTime.boxToLong((long)dataIn.readLong())));
        return var2_2;
    }

    public TaskDescription decode(ByteBuffer byteBuffer) {
        DataInputStream dataIn = new DataInputStream(new ByteBufferInputStream(byteBuffer));
        long taskId = dataIn.readLong();
        int attemptNumber = dataIn.readInt();
        String executorId = dataIn.readUTF();
        String name = dataIn.readUTF();
        int index = dataIn.readInt();
        int partitionId = dataIn.readInt();
        HashMap<String, Object> taskFiles = this.deserializeStringLongMap(dataIn);
        HashMap<String, Object> taskJars = this.deserializeStringLongMap(dataIn);
        Properties properties = new Properties();
        int numProperties = dataIn.readInt();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numProperties).foreach((Function1 & Serializable & scala.Serializable)i -> TaskDescription$.$anonfun$decode$1(dataIn, properties, BoxesRunTime.unboxToInt((Object)i)));
        ByteBuffer serializedTask = byteBuffer.slice();
        return new TaskDescription(taskId, attemptNumber, executorId, name, index, partitionId, (Map<String, Object>)taskFiles, (Map<String, Object>)taskJars, properties, serializedTask);
    }

    public static final /* synthetic */ boolean $anonfun$serializeStringLongMap$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$serializeStringLongMap$2(DataOutputStream dataOut$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        long value = tuple2._2$mcJ$sp();
        dataOut$1.writeUTF(key);
        dataOut$1.writeLong(value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$encode$1(DataOutputStream dataOut$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        dataOut$2.writeUTF(key);
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        dataOut$2.writeInt(bytes.length);
        dataOut$2.write(bytes);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$decode$1(DataInputStream dataIn$2, Properties properties$1, int i) {
        String key = dataIn$2.readUTF();
        int valueLength = dataIn$2.readInt();
        byte[] valueBytes = new byte[valueLength];
        dataIn$2.readFully(valueBytes);
        return properties$1.setProperty(key, new String(valueBytes, StandardCharsets.UTF_8));
    }

    private TaskDescription$() {
        MODULE$ = this;
    }
}

