/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.ShuffleMapTask$;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f!B\u0001\u0003\u0001\u0011Q!AD*ik\u001a4G.Z'baR\u000b7o\u001b\u0006\u0003\u0007\u0011\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0013!\raQbD\u0007\u0002\u0005%\u0011aB\u0001\u0002\u0005)\u0006\u001c8\u000e\u0005\u0002\r!%\u0011\u0011C\u0001\u0002\n\u001b\u0006\u00048\u000b^1ukN\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0011%tG/\u001a:oC2L!a\u0006\u000b\u0003\u000f1{wmZ5oO\"I\u0011\u0004\u0001B\u0001B\u0003%1$I\u0001\bgR\fw-Z%e\u0007\u0001\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u00111!\u00138u\u0013\tIR\u0002C\u0005$\u0001\t\u0005\t\u0015!\u0003\u001cI\u0005q1\u000f^1hK\u0006#H/Z7qi&#\u0017BA\u0012\u000e\u0011!1\u0003A!A!\u0002\u00139\u0013A\u0003;bg.\u0014\u0015N\\1ssB\u0019\u0001fK\u0017\u000e\u0003%R!A\u000b\u0003\u0002\u0013\t\u0014x.\u00193dCN$\u0018B\u0001\u0017*\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u0002\u001d]AJ!aL\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005q\t\u0014B\u0001\u001a\u001e\u0005\u0011\u0011\u0015\u0010^3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0005Y:T\"\u0001\u0003\n\u0005a\"!!\u0003)beRLG/[8o\u0011!Q\u0004A!a\u0001\n\u0013Y\u0014\u0001\u00027pGN,\u0012\u0001\u0010\t\u0004{\u0015CeB\u0001 D\u001d\ty$)D\u0001A\u0015\t\t%$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A)H\u0001\ba\u0006\u001c7.Y4f\u0013\t1uIA\u0002TKFT!\u0001R\u000f\u0011\u00051I\u0015B\u0001&\u0003\u00051!\u0016m]6M_\u000e\fG/[8o\u0011!a\u0005A!a\u0001\n\u0013i\u0015\u0001\u00037pGN|F%Z9\u0015\u00059\u000b\u0006C\u0001\u000fP\u0013\t\u0001VD\u0001\u0003V]&$\bb\u0002*L\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0004\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u001f\u0002\u000b1|7m\u001d\u0011)\u0005M3\u0006C\u0001\u000fX\u0013\tAVDA\u0005ue\u0006t7/[3oi\"A!\f\u0001B\u0001B\u0003%1,A\bm_\u000e\fG\u000e\u0015:pa\u0016\u0014H/[3t!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ev\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!!\u0007A!A!\u0002\u0013i\u0013!F:fe&\fG.\u001b>fIR\u000b7o['fiJL7m\u001d\u0005\nM\u0002\u0011\t\u0011)A\u0005O*\fQA[8c\u0013\u0012\u00042\u0001\b5\u001c\u0013\tIWD\u0001\u0004PaRLwN\\\u0005\u0003M6A\u0011\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c<\u0002\u000b\u0005\u0004\b/\u00133\u0011\u0007qAg\u000e\u0005\u0002pg:\u0011\u0001/\u001d\t\u0003\u007fuI!A]\u000f\u0002\rA\u0013X\rZ3g\u0013\t!XO\u0001\u0004TiJLgn\u001a\u0006\u0003evI!\u0001\\\u0007\t\u0013a\u0004!\u0011!Q\u0001\n5L\u0018\u0001D1qa\u0006#H/Z7qi&#\u0017B\u0001=\u000e\u0011%Y\bA!A!\u0002\u0013ax0A\u0005jg\n\u000b'O]5feB\u0011A$`\u0005\u0003}v\u0011qAQ8pY\u0016\fg.\u0003\u0002|\u001b!9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011A\u0002\u001fj]&$h\b\u0006\r\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\u0001\"\u0001\u0004\u0001\t\re\t\t\u00011\u0001\u001c\u0011\u0019\u0019\u0013\u0011\u0001a\u00017!1a%!\u0001A\u0002\u001dBa\u0001NA\u0001\u0001\u0004)\u0004B\u0002\u001e\u0002\u0002\u0001\u0007A\b\u0003\u0004[\u0003\u0003\u0001\ra\u0017\u0005\u0007I\u0006\u0005\u0001\u0019A\u0017\t\u0011\u0019\f\t\u0001%AA\u0002\u001dD\u0001\u0002\\A\u0001!\u0003\u0005\r!\u001c\u0005\tq\u0006\u0005\u0001\u0013!a\u0001[\"A10!\u0001\u0011\u0002\u0003\u0007A\u0010C\u0004\u0002\u0004\u0001!\t!!\t\u0015\t\u0005\u001d\u00111\u0005\u0005\b\u0003K\ty\u00021\u0001\u001c\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u0011\u0005%\u0002A1A\u0005\nm\nQ\u0002\u001d:fM\u0016\u0014(/\u001a3M_\u000e\u001c\bbBA\u0017\u0001\u0001\u0006I\u0001P\u0001\u000faJ,g-\u001a:sK\u0012dunY:!Q\r\tYC\u0016\u0005\b\u0003g\u0001A\u0011IA\u001b\u0003\u001d\u0011XO\u001c+bg.$2aDA\u001c\u0011!\tI$!\rA\u0002\u0005m\u0012aB2p]R,\u0007\u0010\u001e\t\u0004m\u0005u\u0012bAA \t\tYA+Y:l\u0007>tG/\u001a=u\u0011\u0019\t\u0019\u0005\u0001C!w\u0005\u0011\u0002O]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002]\u001eQ\u0011Q\n\u0002\u0002\u0002#\u0005A!a\u0014\u0002\u001dMCWO\u001a4mK6\u000b\u0007\u000fV1tWB\u0019A\"!\u0015\u0007\u0013\u0005\u0011\u0011\u0011!E\u0001\t\u0005M3CBA)\u0003+\nY\u0006E\u0002\u001d\u0003/J1!!\u0017\u001e\u0005\u0019\te.\u001f*fMB\u0019A$!\u0018\n\u0007\u0005}SD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0002\u0004\u0005EC\u0011AA2)\t\ty\u0005\u0003\u0006\u0002h\u0005E\u0013\u0013!C\u0001\u0003S\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTCAA6U\r9\u0017QN\u0016\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011P\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0005M$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011\u0011QA)#\u0003%\t!a!\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\t)IK\u0002n\u0003[B!\"!#\u0002RE\u0005I\u0011AAB\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cAB!\"!$\u0002RE\u0005I\u0011AAH\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cE*\"!!%+\u0007q\fi\u0007\u0003\u0006\u0002\u0016\u0006E\u0013\u0011!C\u0005\u0003/\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011qT0\u0002\t1\fgnZ\u0005\u0005\u0003G\u000biJ\u0001\u0004PE*,7\r\u001e")
public class ShuffleMapTask
extends Task<MapStatus>
implements Logging {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private transient Seq<TaskLocation> locs;
    private final transient Seq<TaskLocation> preferredLocs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$11() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<String> $lessinit$greater$default$10() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$10();
    }

    public static Option<String> $lessinit$greater$default$9() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<Object> $lessinit$greater$default$8() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$8();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<TaskLocation> locs() {
        return this.locs;
    }

    private void locs_$eq(Seq<TaskLocation> x$1) {
        this.locs = x$1;
    }

    private Seq<TaskLocation> preferredLocs() {
        return this.preferredLocs;
    }

    @Override
    public MapStatus runTask(TaskContext context) {
        MapStatus mapStatus;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long deserializeStartTime = System.currentTimeMillis();
        long deserializeStartCpuTime = threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() : 0L;
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RDD rdd = (RDD)tuple2._1();
        ShuffleDependency dep = (ShuffleDependency)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rdd, (Object)dep);
        Tuple2 tuple23 = tuple22;
        RDD rdd2 = (RDD)tuple23._1();
        ShuffleDependency dep2 = (ShuffleDependency)tuple23._2();
        this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
        this._executorDeserializeCpuTime_$eq(threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() - deserializeStartCpuTime : 0L);
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep2.shuffleHandle(), this.partitionId(), context);
            writer.write(rdd2.iterator(this.partition, context));
            mapStatus = (MapStatus)writer.stop(true).get();
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer != null ? writer.stop(false) : BoxedUnit.UNIT;
            }
            catch (Exception e2) {
                this.log().debug("Could not stop writer", (Throwable)e2);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return mapStatus;
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("ShuffleMapTask(%d, %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.stageId()), BoxesRunTime.boxToInteger((int)this.partitionId())}));
    }

    public ShuffleMapTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, Properties localProperties, byte[] serializedTaskMetrics, Option<Object> jobId, Option<String> appId, Option<String> appAttemptId, boolean isBarrier) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.locs = locs;
        super(stageId, stageAttemptId, partition.index(), localProperties, serializedTaskMetrics, jobId, appId, appAttemptId, isBarrier);
        Logging.$init$(this);
        this.preferredLocs = this.locs() == null ? Nil$.MODULE$ : this.locs().toSet().toSeq();
    }

    public ShuffleMapTask(int partitionId) {
        this(0, 0, null, new Partition(){

            public /* synthetic */ boolean org$apache$spark$Partition$$super$equals(Object x$1) {
                return super.equals(x$1);
            }

            public int hashCode() {
                return Partition.hashCode$(this);
            }

            public boolean equals(Object other) {
                return Partition.equals$(this, other);
            }

            public int index() {
                return 0;
            }
            {
                Partition.$init$(this);
            }
        }, null, new Properties(), null, ShuffleMapTask$.MODULE$.$lessinit$greater$default$8(), ShuffleMapTask$.MODULE$.$lessinit$greater$default$9(), ShuffleMapTask$.MODULE$.$lessinit$greater$default$10(), ShuffleMapTask$.MODULE$.$lessinit$greater$default$11());
    }
}

