/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.AsyncEventQueue$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LiveListenerBus$;
import org.apache.spark.scheduler.LiveListenerBusMetrics;
import org.apache.spark.scheduler.SparkListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.ListenerBus;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\t-\u0011q\"Q:z]\u000e,e/\u001a8u#V,W/\u001a\u0006\u0003\u0007\u0011\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0019I1\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t\u00012\u000b]1sW2K7\u000f^3oKJ\u0014Uo\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00037a\u0011q\u0001T8hO&tw\r\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003\u0011q\u0017-\\3\u0016\u0003}\u0001\"\u0001I\u0014\u000f\u0005\u0005*\u0003C\u0001\u0012\u000f\u001b\u0005\u0019#B\u0001\u0013\u000b\u0003\u0019a$o\\8u}%\u0011aED\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002'\u001d!A1\u0006\u0001B\u0001B\u0003%q$A\u0003oC6,\u0007\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011\u0019wN\u001c4\u0011\u0005=\u0002T\"\u0001\u0003\n\u0005E\"!!C*qCJ\\7i\u001c8g\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014aB7fiJL7m\u001d\t\u0003'UJ!A\u000e\u0002\u0003-1Kg/\u001a'jgR,g.\u001a:CkNlU\r\u001e:jGND\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0004EV\u001c\bCA\n;\u0013\tY$AA\bMSZ,G*[:uK:,'OQ;t\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006;q\u0002\ra\b\u0005\u0006[q\u0002\rA\f\u0005\u0006gq\u0002\r\u0001\u000e\u0005\u0006qq\u0002\r!\u000f\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0003))g/\u001a8u#V,W/Z\u000b\u0002\u000fB\u0019\u0001jT)\u000e\u0003%S!AS&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002M\u001b\u0006!Q\u000f^5m\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U%\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\u0005M\u0011\u0016BA*\u0003\u0005I\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\t\rU\u0003\u0001\u0015!\u0003H\u0003-)g/\u001a8u#V,W/\u001a\u0011\t\u000f]\u0003!\u0019!C\u00051\u0006QQM^3oi\u000e{WO\u001c;\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001X%\u0002\r\u0005$x.\\5d\u0013\tq6L\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa\u0001\u0019\u0001!\u0002\u0013I\u0016aC3wK:$8i\\;oi\u0002BqA\u0019\u0001C\u0002\u0013%\u0001,\u0001\u000bee>\u0004\b/\u001a3Fm\u0016tGo]\"pk:$XM\u001d\u0005\u0007I\u0002\u0001\u000b\u0011B-\u0002+\u0011\u0014x\u000e\u001d9fI\u00163XM\u001c;t\u0007>,h\u000e^3sA!9a\r\u0001a\u0001\n\u00139\u0017a\u00057bgR\u0014V\r]8siRKW.Z:uC6\u0004X#\u00015\u0011\u00055I\u0017B\u00016\u000f\u0005\u0011auN\\4\t\u000f1\u0004\u0001\u0019!C\u0005[\u00069B.Y:u%\u0016\u0004xN\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0003]F\u0004\"!D8\n\u0005At!\u0001B+oSRDqA]6\u0002\u0002\u0003\u0007\u0001.A\u0002yIEBa\u0001\u001e\u0001!B\u0013A\u0017\u0001\u00067bgR\u0014V\r]8siRKW.Z:uC6\u0004\b\u0005\u000b\u0002tmB\u0011Qb^\u0005\u0003q:\u0011\u0001B^8mCRLG.\u001a\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0003=awn\u001a#s_B\u0004X\rZ#wK:$X#\u0001?\u0011\u0005ik\u0018B\u0001@\\\u00055\tEo\\7jG\n{w\u000e\\3b]\"9\u0011\u0011\u0001\u0001!\u0002\u0013a\u0018\u0001\u00057pO\u0012\u0013x\u000e\u001d9fI\u00163XM\u001c;!\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9!\u0001\u0002tGV\u0011\u0011\u0011\u0002\t\u0004_\u0005-\u0011bAA\u0007\t\ta1\u000b]1sW\u000e{g\u000e^3yi\"I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111C\u0001\u0007g\u000e|F%Z9\u0015\u00079\f)\u0002C\u0005s\u0003\u001f\t\t\u00111\u0001\u0002\n!A\u0011\u0011\u0004\u0001!B\u0013\tI!A\u0002tG\u0002B\u0001\"!\b\u0001\u0005\u0004%Ia_\u0001\bgR\f'\u000f^3e\u0011\u001d\t\t\u0003\u0001Q\u0001\nq\f\u0001b\u001d;beR,G\r\t\u0005\t\u0003K\u0001!\u0019!C\u0005w\u000691\u000f^8qa\u0016$\u0007bBA\u0015\u0001\u0001\u0006I\u0001`\u0001\tgR|\u0007\u000f]3eA!I\u0011Q\u0006\u0001C\u0002\u0013%\u0011qF\u0001\u000eIJ|\u0007\u000f]3e\u000bZ,g\u000e^:\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003\u007fi!!!\u000e\u000b\u0007M\n9D\u0003\u0003\u0002:\u0005m\u0012\u0001C2pI\u0006D\u0017\r\\3\u000b\u0005\u0005u\u0012aA2p[&!\u0011\u0011IA\u001b\u0005\u001d\u0019u.\u001e8uKJD\u0001\"!\u0012\u0001A\u0003%\u0011\u0011G\u0001\u000fIJ|\u0007\u000f]3e\u000bZ,g\u000e^:!\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY%\u0001\bqe>\u001cWm]:j]\u001e$\u0016.\\3\u0016\u0005\u00055\u0003\u0003BA\u001a\u0003\u001fJA!!\u0015\u00026\t)A+[7fe\"A\u0011Q\u000b\u0001!\u0002\u0013\ti%A\bqe>\u001cWm]:j]\u001e$\u0016.\\3!\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY&\u0001\beSN\u0004\u0018\r^2i)\"\u0014X-\u00193\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rT*\u0001\u0003mC:<\u0017\u0002BA4\u0003C\u0012a\u0001\u00165sK\u0006$\u0007\u0002CA6\u0001\u0001\u0006I!!\u0018\u0002\u001f\u0011L7\u000f]1uG\"$\u0006N]3bI\u0002Bq!a\u001c\u0001\t\u0013\t\t(\u0001\u0005eSN\u0004\u0018\r^2i)\u0005q\u0007bBA;\u0001\u0011E\u0013qO\u0001\tO\u0016$H+[7feR!\u0011\u0011PA@!\u0015i\u00111PA'\u0013\r\tiH\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u0005\u00151\u000fa\u0001\u0003\u0007\u000b\u0001\u0002\\5ti\u0016tWM\u001d\t\u0004'\u0005\u0015\u0015bAAD\u0005\t12\u000b]1sW2K7\u000f^3oKJLe\u000e^3sM\u0006\u001cW\r\u0003\u0005\u0002\f\u0002!\tAAAG\u0003\u0015\u0019H/\u0019:u)\rq\u0017q\u0012\u0005\t\u0003\u000b\tI\t1\u0001\u0002\n!A\u00111\u0013\u0001\u0005\u0002\t\t\t(\u0001\u0003ti>\u0004\bbBAL\u0001\u0011\u0005\u0011\u0011T\u0001\u0005a>\u001cH\u000fF\u0002o\u00037Cq!!(\u0002\u0016\u0002\u0007\u0011+A\u0003fm\u0016tG\u000fC\u0004\u0002\"\u0002!\t!a)\u0002\u001d]\f\u0017\u000e^+oi&dW)\u001c9usR!\u0011QUAV!\ri\u0011qU\u0005\u0004\u0003Ss!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[\u000by\n1\u0001i\u0003!!W-\u00193mS:,\u0007bBAY\u0001\u0011\u0005\u00131W\u0001\u0016e\u0016lwN^3MSN$XM\\3s\u001f:,%O]8s)\rq\u0017Q\u0017\u0005\t\u0003\u0003\u000by\u000b1\u0001\u0002\u0004\"q\u0011\u0011\u0018\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002<\u0006}\u0016aD:va\u0016\u0014H\u0005]8tiR{\u0017\t\u001c7\u0015\u00079\fi\fC\u0004\u0002\u001e\u0006]\u0006\u0019A)\n\t\u0005\u0005\u00171Y\u0001\na>\u001cH\u000fV8BY2LA!!2\u0002H\nYA*[:uK:,'OQ;t\u0015\taEaB\u0004\u0002L\nAI!!4\u0002\u001f\u0005\u001b\u0018P\\2Fm\u0016tG/U;fk\u0016\u00042aEAh\r\u0019\t!\u0001#\u0003\u0002RN\u0019\u0011q\u001a\u0007\t\u000fu\ny\r\"\u0001\u0002VR\u0011\u0011Q\u001a\u0005\u000b\u00033\fyM1A\u0005\u0002\u0005m\u0017a\u0003)P\u0013N{ej\u0018)J\u00192+\"!!8\u0013\t\u0005}G\"\u0015\u0004\b\u0003C\f\u0019\u000fAAo\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0011%\t)/a4!\u0002\u0013\ti.\u0001\u0007Q\u001f&\u001bvJT0Q\u00132c\u0005\u0005")
public class AsyncEventQueue
implements SparkListenerBus {
    private final String name;
    private final LiveListenerBusMetrics metrics;
    private final LiveListenerBus bus;
    private final LinkedBlockingQueue<SparkListenerEvent> org$apache$spark$scheduler$AsyncEventQueue$$eventQueue;
    private final AtomicLong eventCount;
    private final AtomicLong droppedEventsCounter;
    private volatile long lastReportTimestamp;
    private final AtomicBoolean logDroppedEvent;
    private SparkContext org$apache$spark$scheduler$AsyncEventQueue$$sc;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private final Counter droppedEvents;
    private final Timer processingTime;
    private final Thread dispatchThread;
    private final CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static SparkListenerEvent POISON_PILL() {
        return AsyncEventQueue$.MODULE$.POISON_PILL();
    }

    @Override
    public void doPostEvent(SparkListenerInterface listener, SparkListenerEvent event) {
        SparkListenerBus.doPostEvent$(this, listener, event);
    }

    @Override
    public List<SparkListenerInterface> listeners() {
        return ListenerBus.listeners$(this);
    }

    @Override
    public final void addListener(Object listener) {
        ListenerBus.addListener$(this, listener);
    }

    @Override
    public final void removeListener(Object listener) {
        ListenerBus.removeListener$(this, listener);
    }

    @Override
    public void postToAll(Object event) {
        ListenerBus.postToAll$(this, event);
    }

    @Override
    public boolean isIgnorableException(Throwable e) {
        return ListenerBus.isIgnorableException$(this, e);
    }

    @Override
    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.findListenersByClass$(this, evidence$1);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers() {
        return this.org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    }

    @Override
    public final void org$apache$spark$util$ListenerBus$_setter_$org$apache$spark$util$ListenerBus$$listenersPlusTimers_$eq(CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> x$1) {
        this.org$apache$spark$util$ListenerBus$$listenersPlusTimers = x$1;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ void super$postToAll(SparkListenerEvent event) {
        ListenerBus.postToAll$(this, event);
    }

    public String name() {
        return this.name;
    }

    public LinkedBlockingQueue<SparkListenerEvent> org$apache$spark$scheduler$AsyncEventQueue$$eventQueue() {
        return this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue;
    }

    private AtomicLong eventCount() {
        return this.eventCount;
    }

    private AtomicLong droppedEventsCounter() {
        return this.droppedEventsCounter;
    }

    private long lastReportTimestamp() {
        return this.lastReportTimestamp;
    }

    private void lastReportTimestamp_$eq(long x$1) {
        this.lastReportTimestamp = x$1;
    }

    private AtomicBoolean logDroppedEvent() {
        return this.logDroppedEvent;
    }

    public SparkContext org$apache$spark$scheduler$AsyncEventQueue$$sc() {
        return this.org$apache$spark$scheduler$AsyncEventQueue$$sc;
    }

    private void org$apache$spark$scheduler$AsyncEventQueue$$sc_$eq(SparkContext x$1) {
        this.org$apache$spark$scheduler$AsyncEventQueue$$sc = x$1;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private Counter droppedEvents() {
        return this.droppedEvents;
    }

    private Timer processingTime() {
        return this.processingTime;
    }

    private Thread dispatchThread() {
        return this.dispatchThread;
    }

    public void org$apache$spark$scheduler$AsyncEventQueue$$dispatch() {
        LiveListenerBus$.MODULE$.withinListenerThread().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            SparkListenerEvent next = this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().take();
            while (true) {
                SparkListenerEvent sparkListenerEvent = next;
                SparkListenerEvent sparkListenerEvent2 = AsyncEventQueue$.MODULE$.POISON_PILL();
                if (!(sparkListenerEvent == null ? sparkListenerEvent2 != null : !sparkListenerEvent.equals(sparkListenerEvent2))) break;
                Timer.Context ctx = this.processingTime().time();
                try {
                    this.super$postToAll(next);
                }
                finally {
                    ctx.stop();
                }
                this.eventCount().decrementAndGet();
                next = this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().take();
            }
            return this.eventCount().decrementAndGet();
        });
    }

    @Override
    public Option<Timer> getTimer(SparkListenerInterface listener) {
        return this.metrics.getTimerForListenerClass(listener.getClass().asSubclass(SparkListenerInterface.class));
    }

    public void start(SparkContext sc) {
        if (!this.started().compareAndSet(false, true)) {
            throw new IllegalStateException(new StringBuilder(17).append(this.name()).append(" already started!").toString());
        }
        this.org$apache$spark$scheduler$AsyncEventQueue$$sc_$eq(sc);
        this.dispatchThread().start();
    }

    public void stop() {
        block2: {
            if (!this.started().get()) {
                throw new IllegalStateException(new StringBuilder(44).append("Attempted to stop ").append(this.name()).append(" that has not yet started!").toString());
            }
            if (this.stopped().compareAndSet(false, true)) {
                this.eventCount().incrementAndGet();
                this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().put(AsyncEventQueue$.MODULE$.POISON_PILL());
            }
            Thread thread = Thread.currentThread();
            Thread thread2 = this.dispatchThread();
            if (!(thread == null ? thread2 != null : !thread.equals(thread2))) break block2;
            this.dispatchThread().join();
        }
    }

    public void post(SparkListenerEvent event) {
        block3: {
            if (this.stopped().get()) {
                return;
            }
            this.eventCount().incrementAndGet();
            if (this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().offer(event)) {
                return;
            }
            this.eventCount().decrementAndGet();
            this.droppedEvents().inc();
            this.droppedEventsCounter().incrementAndGet();
            if (this.logDroppedEvent().compareAndSet(false, true)) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(162).append("Dropping event from queue ").append(this.name()).append(". ").append("This likely means one of the listeners is too slow and cannot keep up with ").append("the rate at which tasks are being started by the scheduler.").toString());
            }
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Dropping event ").append(event).toString());
            long droppedCount = this.droppedEventsCounter().get();
            if (droppedCount <= 0L || System.currentTimeMillis() - this.lastReportTimestamp() < 60000L || !this.droppedEventsCounter().compareAndSet(droppedCount, 0L)) break block3;
            long prevLastReportTimestamp = this.lastReportTimestamp();
            this.lastReportTimestamp_$eq(System.currentTimeMillis());
            Date previous = new Date(prevLastReportTimestamp);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dropped ").append(droppedCount).append(" events from ").append(this.name()).append(" since ").append(previous).append(".").toString());
        }
    }

    public boolean waitUntilEmpty(long deadline) {
        while (this.eventCount().get() != 0L) {
            if (System.currentTimeMillis() > deadline) {
                return false;
            }
            Thread.sleep(10L);
        }
        return true;
    }

    @Override
    public void removeListenerOnError(SparkListenerInterface listener) {
        this.bus.removeListener(listener);
    }

    public AsyncEventQueue(String name, SparkConf conf, LiveListenerBusMetrics metrics, LiveListenerBus bus) {
        this.name = name;
        this.metrics = metrics;
        this.bus = bus;
        Logging.$init$(this);
        ListenerBus.$init$(this);
        SparkListenerBus.$init$(this);
        this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue = new LinkedBlockingQueue(BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.LISTENER_BUS_EVENT_QUEUE_CAPACITY())));
        this.eventCount = new AtomicLong();
        this.droppedEventsCounter = new AtomicLong(0L);
        this.lastReportTimestamp = 0L;
        this.logDroppedEvent = new AtomicBoolean(false);
        this.org$apache$spark$scheduler$AsyncEventQueue$$sc = null;
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.droppedEvents = metrics.metricRegistry().counter(new StringBuilder(23).append("queue.").append(name).append(".numDroppedEvents").toString());
        this.processingTime = metrics.metricRegistry().timer(new StringBuilder(29).append("queue.").append(name).append(".listenerProcessingTime").toString());
        metrics.metricRegistry().remove(new StringBuilder(11).append("queue.").append(name).append(".size").toString());
        metrics.metricRegistry().register(new StringBuilder(11).append("queue.").append(name).append(".size").toString(), (Metric)new Gauge<Object>(this){
            private final /* synthetic */ AsyncEventQueue $outer;

            public int getValue() {
                return this.$outer.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.dispatchThread = new Thread(this){
            private final /* synthetic */ AsyncEventQueue $outer;

            public void run() {
                Utils$.MODULE$.tryOrStopSparkContext(this.$outer.org$apache$spark$scheduler$AsyncEventQueue$$sc(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$scheduler$AsyncEventQueue$$dispatch());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(21).append("spark-listener-group-").append($outer.name()).toString());
                this.setDaemon(true);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.AsyncEventQueue$$anon$2 )}, serializedLambda);
            }
        };
    }
}

