/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.primitives.Longs;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t]h\u0001B\u0001\u0003\u0001-\u0011qb\u00159be.D\u0015\rZ8paV#\u0018\u000e\u001c\u0006\u0003\u0007\u0011\ta\u0001Z3qY>L(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0005j]R,'O\\1m\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\ngB\f'o[\"p]\u001a,\u0012\u0001\t\t\u0003C\tj\u0011\u0001B\u0005\u0003G\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\r\u0015\u0002\u0001\u0015!\u0003!\u0003)\u0019\b/\u0019:l\u0007>tg\r\t\u0005\bO\u0001\u0011\r\u0011\"\u0001)\u0003\u0011\u0019wN\u001c4\u0016\u0003%\u0002\"A\u000b\u0018\u000e\u0003-R!a\n\u0017\u000b\u000552\u0011A\u00025bI>|\u0007/\u0003\u00020W\ti1i\u001c8gS\u001e,(/\u0019;j_:Da!\r\u0001!\u0002\u0013I\u0013!B2p]\u001a\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0004:v]\u0006\u001b8\u000b]1sWV\u001bXM\u001d\u000b\u0003ka\u0002\"!\u0004\u001c\n\u0005]r!\u0001B+oSRDQ!\u000f\u001aA\u0002i\nAAZ;oGB\u0019QbO\u001b\n\u0005qr!!\u0003$v]\u000e$\u0018n\u001c81\u0011\u0015q\u0004\u0001\"\u0001@\u0003=\u0019'/Z1uKN\u0003\u0018M]6Vg\u0016\u0014H#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rc\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\u0015\u0013%\u0001F+tKJ<%o\\;q\u0013:4wN]7bi&|g\u000eC\u0003H\u0001\u0011\u0005\u0001*A\nue\u0006t7OZ3s\u0007J,G-\u001a8uS\u0006d7\u000fF\u00026\u0013.CQA\u0013$A\u0002\u0001\u000baa]8ve\u000e,\u0007\"\u0002'G\u0001\u0004\u0001\u0015\u0001\u00023fgRDQA\u0014\u0001\u0005\u0002=\u000bA%\u00199qK:$7kM!oIN\u0003\u0018M]6IC\u0012|w\u000e]\"p]\u001aLw-\u001e:bi&|gn\u001d\u000b\u0004kA\u000b\u0006\"B\u0014N\u0001\u0004\u0001\u0003\"\u0002*N\u0001\u0004I\u0013A\u00035bI>|\u0007oQ8oM\")A\u000b\u0001C\u0001+\u0006A\u0012\r\u001d9f]\u0012\u001c\u0006/\u0019:l\u0011\u0006$wn\u001c9D_:4\u0017nZ:\u0015\u0007U2v\u000bC\u0003('\u0002\u0007\u0001\u0005C\u0003S'\u0002\u0007\u0011\u0006C\u0003U\u0001\u0011\u0005\u0011\fF\u000265>DQa\u0017-A\u0002q\u000baa\u001d:d\u001b\u0006\u0004\b\u0003B/cI\u0012l\u0011A\u0018\u0006\u0003?\u0002\f\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0005t\u0011AC2pY2,7\r^5p]&\u00111M\u0018\u0002\u0004\u001b\u0006\u0004\bCA3m\u001d\t1'\u000e\u0005\u0002h\u001d5\t\u0001N\u0003\u0002j\u0015\u00051AH]8pizJ!a\u001b\b\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003W:AQ\u0001\u001d-A\u0002E\fq\u0001Z3ti6\u000b\u0007\u000f\u0005\u0003sk\u0012$W\"A:\u000b\u0005Q\u0004\u0017aB7vi\u0006\u0014G.Z\u0005\u0003mN\u0014q\u0001S1tQ6\u000b\u0007\u000fC\u0003y\u0001\u0011\u0005\u00110\u0001\toK^\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011\u0011F\u001f\u0005\u0006O]\u0004\r\u0001\t\u0005\u0006y\u0002!\t!`\u0001\u000fC\u0012$7I]3eK:$\u0018.\u00197t)\t)d\u0010C\u0003(w\u0002\u0007q\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001L\u0001\u0007[\u0006\u0004(/\u001a3\n\t\u0005%\u00111\u0001\u0002\b\u0015>\u00147i\u001c8g\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\t\u0011$\u00193e\u0007V\u0014(/\u001a8u+N,'o\u0011:fI\u0016tG/[1mgR\u0019Q'!\u0005\t\u0011\u0005M\u00111\u0002a\u0001\u0003+\tQa\u0019:fIN\u00042!QA\f\u0013\r\tIB\u0011\u0002\f\u0007J,G-\u001a8uS\u0006d7\u000fC\u0004\u0002\u001e\u0001!\t!a\b\u0002'1|w-\u001b8Vg\u0016\u0014hI]8n\u0017\u0016LH/\u00192\u0015\u000bU\n\t#!\n\t\u000f\u0005\r\u00121\u0004a\u0001I\u0006i\u0001O]5oG&\u0004\u0018\r\u001c(b[\u0016Dq!a\n\u0002\u001c\u0001\u0007A-\u0001\blKf$\u0018M\u0019$jY\u0016t\u0017-\\3\t\u0011\u0005-\u0002\u0001\"\u0001\u0005\u0003[\t1#\u00193e\t\u0016dWmZ1uS>tGk\\6f]N$R!NA\u0018\u0003\u007fA\u0001\"!\r\u0002*\u0001\u0007\u00111G\u0001\u0007i>\\WM\\:\u0011\u000b5\t)$!\u000f\n\u0007\u0005]bBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0003wI1!!\u0010\u000f\u0005\u0011\u0011\u0015\u0010^3\t\ry\tI\u00031\u0001!\u0011!\t\u0019\u0005\u0001C\u0001\t\u0005\u0015\u0013AH4fi\u001a\u001b&)\u001f;fgJ+\u0017\rZ(o)\"\u0014X-\u00193DC2d'-Y2l)\t\t9\u0005\u0005\u0003\u000ew\u0005%\u0003cA\u0007\u0002L%\u0019\u0011Q\n\b\u0003\t1{gn\u001a\u0005\t\u0003#\u0002A\u0011\u0001\u0003\u0002F\u0005\ts-\u001a;G'\nKH/Z:Xe&$H/\u001a8P]RC'/Z1e\u0007\u0006dGNY1dW\"9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013\u0001\u00057jgRdU-\u00194Ti\u0006$Xo]3t)\u0019\tI&a\u001e\u0002\u0000A1\u00111LA3\u0003WrA!!\u0018\u0002b9\u0019q-a\u0018\n\u0003=I1!a\u0019\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\t\u00191+Z9\u000b\u0007\u0005\rd\u0002\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bL\u0001\u0003MNLA!!\u001e\u0002p\tQa)\u001b7f'R\fG/^:\t\u0011\u0005E\u00141\u000ba\u0001\u0003s\u0002B!!\u001c\u0002|%!\u0011QPA8\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\t\u0003\u0003\u000b\u0019\u00061\u0001\u0002\u0004\u0006A!-Y:f!\u0006$\b\u000e\u0005\u0003\u0002n\u0005\u0015\u0015\u0002BAD\u0003_\u0012A\u0001U1uQ\"9\u0011Q\u000b\u0001\u0005\u0002\u0005-ECBA-\u0003\u001b\u000by\t\u0003\u0005\u0002r\u0005%\u0005\u0019AA=\u0011!\t\t*!#A\u0002\u0005-\u0014A\u00032bg\u0016\u001cF/\u0019;vg\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015a\u00057jgRdU-\u00194ESJ\u001cF/\u0019;vg\u0016\u001cHCBA-\u00033\u000bY\n\u0003\u0005\u0002r\u0005M\u0005\u0019AA=\u0011!\t\t)a%A\u0002\u0005\r\u0005bBAK\u0001\u0011\u0005\u0011q\u0014\u000b\u0007\u00033\n\t+a)\t\u0011\u0005E\u0014Q\u0014a\u0001\u0003sB\u0001\"!%\u0002\u001e\u0002\u0007\u00111\u000e\u0005\b\u0003O\u0003A\u0011AAU\u0003)I7o\u00127pEB\u000bG\u000f\u001b\u000b\u0005\u0003W\u000b\t\fE\u0002\u000e\u0003[K1!a,\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"a-\u0002&\u0002\u0007\u00111Q\u0001\ba\u0006$H/\u001a:o\u0011\u001d\t9\f\u0001C\u0001\u0003s\u000b\u0001b\u001a7pEB\u000bG\u000f\u001b\u000b\u0005\u0003w\u000bi\f\u0005\u0004\u0002\\\u0005\u0015\u00141\u0011\u0005\t\u0003g\u000b)\f1\u0001\u0002\u0004\"9\u0011q\u0017\u0001\u0005\u0002\u0005\u0005GCBA^\u0003\u0007\f)\r\u0003\u0005\u0002r\u0005}\u0006\u0019AA=\u0011!\t\u0019,a0A\u0002\u0005\r\u0005bBAe\u0001\u0011\u0005\u00111Z\u0001\u0014O2|'\rU1uQ&3g*Z2fgN\f'/\u001f\u000b\u0005\u0003w\u000bi\r\u0003\u0005\u00024\u0006\u001d\u0007\u0019AAB\u0011\u001d\tI\r\u0001C\u0001\u0003#$b!a/\u0002T\u0006U\u0007\u0002CA9\u0003\u001f\u0004\r!!\u001f\t\u0011\u0005M\u0016q\u001aa\u0001\u0003\u0007Cq!!7\u0001\t\u0003\tY.A\bmSN$h)\u001b7fgN{'\u000f^3e))\ti.a8\u0002d\u0006\u001d\u00181\u001e\t\u0006\u001b\u0005U\u00121\u000e\u0005\t\u0003C\f9\u000e1\u0001\u0002z\u0005A!/Z7pi\u001645\u000f\u0003\u0005\u0002f\u0006]\u0007\u0019AAB\u0003\r!\u0017N\u001d\u0005\b\u0003S\f9\u000e1\u0001e\u0003\u0019\u0001(/\u001a4jq\"9\u0011Q^Al\u0001\u0004!\u0017aD3yG2,8/[8o'V4g-\u001b=\t\u0011\u0005E\b\u0001\"\u0001\u0005\u0003g\f1dZ3u'V4g-\u001b=G_J\u001c%/\u001a3f]RL\u0017\r\\:QCRDG\u0003BA{\u0003w\u00042!DA|\u0013\r\tIP\u0004\u0002\u0004\u0013:$\b\u0002CA\u007f\u0003_\u0004\r!a!\u0002\u001f\r\u0014X\rZ3oi&\fGn\u001d)bi\"D\u0011B!\u0001\u0001\u0005\u0004%IAa\u0001\u0002'!\u000bEiT(Q?\u000e{eJR0Q\u0003R#VI\u0015(\u0016\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005#i!A!\u0003\u000b\t\t-!QB\u0001\t[\u0006$8\r[5oO*\u0019!q\u0002\b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005'\u0011IAA\bV]\u0006t7\r[8sK\u0012\u0014VmZ3y\u0011!\u00119\u0002\u0001Q\u0001\n\t\u0015\u0011\u0001\u0006%B\t>{\u0005kX\"P\u001d\u001a{\u0006+\u0011+U\u000bJs\u0005\u0005C\u0004\u0003\u001c\u0001!\tA!\b\u00023M,(m\u001d;jiV$X\rS1e_>\u0004h+\u0019:jC\ndWm\u001d\u000b\u0006I\n}!1\u0005\u0005\b\u0005C\u0011I\u00021\u0001e\u0003\u0011!X\r\u001f;\t\rI\u0013I\u00021\u0001*\u0011!\u00119\u0003\u0001C\u0001\t\t%\u0012A\u00033v[B$vn[3ogR!!1\u0006B\u0019!\u0015\tYF!\fe\u0013\u0011\u0011y#!\u001b\u0003\u0011%#XM]1cY\u0016D\u0001Ba\r\u0003&\u0001\u0007\u0011QC\u0001\fGJ,G-\u001a8uS\u0006d7\u000f\u0003\u0005\u00038\u0001!\t\u0001\u0002B\u001d\u00035!xn[3o)>\u001cFO]5oOR\u0019AMa\u000f\t\u0011\tu\"Q\u0007a\u0001\u0005\u007f\tQ\u0001^8lK:\u0004DA!\u0011\u0003PA1!1\tB$\u0005\u0017j!A!\u0012\u000b\u0007\tu\")\u0003\u0003\u0003J\t\u0015#!\u0002+pW\u0016t\u0007\u0003\u0002B'\u0005\u001fb\u0001\u0001\u0002\u0007\u0003R\tm\u0012\u0011!A\u0001\u0006\u0003\u0011\u0019FA\u0002`IE\nBA!\u0016\u0003\\A\u0019QBa\u0016\n\u0007\tecBA\u0004O_RD\u0017N\\4\u0011\t\t\r#QL\u0005\u0005\u0005?\u0012)EA\bU_.,g.\u00133f]RLg-[3s\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005K\n\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005M\"q\r\u0005\t\u0003'\u0011\t\u00071\u0001\u0002\u0016!9!1\u000e\u0001\u0005\u0002\t5\u0014a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$B!!\u0006\u0003p!A!\u0011\u000fB5\u0001\u0004\t\u0019$\u0001\u0006u_.,gNQ=uKNDqA!\u001e\u0001\t\u0003\u00119(A\u0006jgB\u0013x\u000e_=Vg\u0016\u0014H\u0003BAV\u0005sBqAa\u001f\u0003t\u0001\u0007\u0001)A\u0002vO&D3\u0001\u0001B@!\u0011\u0011\tIa\"\u000e\u0005\t\r%b\u0001BC\t\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%%1\u0011\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0004\b\u0005\u001b\u0013\u0001\u0012\u0001BH\u0003=\u0019\u0006/\u0019:l\u0011\u0006$wn\u001c9Vi&d\u0007c\u0001\u000f\u0003\u0012\u001a1\u0011A\u0001E\u0001\u0005'\u001b2A!%\r\u0011\u001dI\"\u0011\u0013C\u0001\u0005/#\"Aa$\t\u0017\tm%\u0011\u0013EC\u0002\u0013%!QT\u0001\tS:\u001cH/\u00198dKV\t1\u0004\u0003\u0006\u0003\"\nE%\u0019!C\u0001\u0005G\u000bqd\u0015)B%.{\u0016,\u0011*O?\u000e\u0013V\tR*`)\u0016k\u0005kX#Y)\u0016s5+S(O+\t\u0011)\u000b\u0005\u0003\u0003(\nEVB\u0001BU\u0015\u0011\u0011YK!,\u0002\t1\fgn\u001a\u0006\u0003\u0005_\u000bAA[1wC&\u0019QN!+\t\u0013\tU&\u0011\u0013Q\u0001\n\t\u0015\u0016\u0001I*Q\u0003J[u,W!S\u001d~\u001b%+\u0012#T?R+U\nU0F1R+ejU%P\u001d\u0002B!B!/\u0003\u0012\n\u0007I\u0011\u0001BR\u0003y\u0019\u0006+\u0011*L?f\u000b%KT0D%\u0016#5kX\"P+:#VIU0E\u000b2KU\nC\u0005\u0003>\nE\u0005\u0015!\u0003\u0003&\u0006y2\u000bU!S\u0017~K\u0016I\u0015(`\u0007J+EiU0D\u001fVsE+\u0012*`\t\u0016c\u0015*\u0014\u0011\t\u0017\t\u0005'\u0011\u0013b\u0001\n\u0003!!1Y\u0001&+B#\u0015\tV#`\u0013:\u0003V\u000bV0N\u000bR\u0013\u0016jQ*`\u0013:#VI\u0015,B\u0019~\u0013ViQ(S\tN+\"!!>\t\u0013\t\u001d'\u0011\u0013Q\u0001\n\u0005U\u0018AJ+Q\t\u0006#ViX%O!V#v,T#U%&\u001b5kX%O)\u0016\u0013f+\u0011'`%\u0016\u001buJ\u0015#TA!Y!1\u001aBI\u0005\u0004%\t\u0001\u0002BR\u0003Y\u0019\u0006+\u0011*L?\"\u000bEiT(Q?\u000e{eJR0G\u00132+\u0005\"\u0003Bh\u0005#\u0003\u000b\u0011\u0002BS\u0003]\u0019\u0006+\u0011*L?\"\u000bEiT(Q?\u000e{eJR0G\u00132+\u0005\u0005\u0003\u0005\u0003T\nEE\u0011\u0001BO\u0003\r9W\r\u001e\u0005\n\u0005/\u0014\t\n\"\u0001\u0005\u00053\f\u0011D\\3yi\u000e\u0013X\rZ3oi&\fGNU3oK^\fG\u000eV5nKR1\u0011\u0011\nBn\u0005?D\u0001B!8\u0003V\u0002\u0007\u0011\u0011J\u0001\u000fKb\u0004\u0018N]1uS>tG)\u0019;f\u0011\u00199#Q\u001ba\u0001A!A\u0001P!%\u0005\u0002\u0011\u0011\u0019\u000fF\u0002*\u0005KDaa\nBq\u0001\u0004\u0001\u0003b\u0002(\u0003\u0012\u0012%!\u0011\u001e\u000b\u0006k\t-(Q\u001e\u0005\u0007O\t\u001d\b\u0019\u0001\u0011\t\rI\u00139\u000f1\u0001*\u0011\u001d!&\u0011\u0013C\u0005\u0005c$R!\u000eBz\u0005kDaa\nBx\u0001\u0004\u0001\u0003B\u0002*\u0003p\u0002\u0007\u0011\u0006")
public class SparkHadoopUtil
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration conf;
    private final UnanchoredRegex HADOOP_CONF_PATTERN;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static SparkHadoopUtil get() {
        return SparkHadoopUtil$.MODULE$.get();
    }

    public static String SPARK_YARN_CREDS_COUNTER_DELIM() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM();
    }

    public static String SPARK_YARN_CREDS_TEMP_EXTENSION() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration conf() {
        return this.conf;
    }

    public void runAsSparkUser(Function0<BoxedUnit> func) {
        this.createSparkUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(null, func){
            private final Function0 func$1;

            public void run() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public UserGroupInformation createSparkUser() {
        void var2_2;
        String user = Utils$.MODULE$.getCurrentUserName();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("creating UGI for user: ").append(user).toString());
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        this.transferCredentials(UserGroupInformation.getCurrentUser(), ugi);
        return var2_2;
    }

    public void transferCredentials(UserGroupInformation source, UserGroupInformation dest) {
        dest.addCredentials(source.getCredentials());
    }

    public void appendS3AndSparkHadoopConfigurations(SparkConf conf, Configuration hadoopConf) {
        SparkHadoopUtil$.MODULE$.org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopConfigurations(conf, hadoopConf);
    }

    public void appendSparkHadoopConfigs(SparkConf conf, Configuration hadoopConf) {
        SparkHadoopUtil$.MODULE$.org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(conf, hadoopConf);
    }

    public void appendSparkHadoopConfigs(Map<String, String> srcMap, HashMap<String, String> destMap) {
        srcMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil.$anonfun$appendSparkHadoopConfigs$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil.$anonfun$appendSparkHadoopConfigs$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Option option = destMap.put((Object)key.substring("spark.hadoop.".length()), (Object)value);
            return option;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration(conf);
        hadoopConf.addResource(SparkHadoopUtil$.MODULE$.SPARK_HADOOP_CONF_FILE());
        return var2_2;
    }

    public void addCredentials(JobConf conf) {
        Credentials jobCreds = conf.getCredentials();
        jobCreds.mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
    }

    public void addCurrentUserCredentials(Credentials creds) {
        UserGroupInformation.getCurrentUser().addCredentials(creds);
    }

    public void loginUserFromKeytab(String principalName, String keytabFilename) {
        if (!new File(keytabFilename).exists()) {
            throw new SparkException(new java.lang.StringBuilder(28).append("Keytab file: ").append(keytabFilename).append(" does not exist").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Attempting to login to Kerberos ").append(new java.lang.StringBuilder(30).append("using principal: ").append(principalName).append(" and keytab: ").append(keytabFilename).toString()).toString());
        UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keytabFilename);
    }

    public void addDelegationTokens(byte[] tokens, SparkConf sparkConf) {
        UserGroupInformation.setConfiguration((Configuration)this.newConfiguration(sparkConf));
        Credentials creds = this.deserialize(tokens);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating delegation tokens for current user.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Adding/updating delegation tokens ").append(this.dumpTokens(creds)).toString());
        this.addCurrentUserCredentials(creds);
    }

    public Function0<Object> getFSBytesReadOnThreadCallback() {
        JFunction0.mcJ.sp & Serializable & scala.Serializable f = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(FileSystem.getAllStatistics()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)SparkHadoopUtil.$anonfun$getFSBytesReadOnThreadCallback$2(x$3)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Tuple2.mcJJ.sp baseline = new Tuple2.mcJJ.sp(Thread.currentThread().getId(), f.apply$mcJ$sp());
        return new Function0.mcJ.sp(null, (Function0)f, (Tuple2)baseline){
            private final HashMap<Object, Object> org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap;
            private final Function0 f$1;
            private final Tuple2 baseline$1;

            public boolean apply$mcZ$sp() {
                return Function0.apply$mcZ$sp$((Function0)this);
            }

            public byte apply$mcB$sp() {
                return Function0.apply$mcB$sp$((Function0)this);
            }

            public char apply$mcC$sp() {
                return Function0.apply$mcC$sp$((Function0)this);
            }

            public double apply$mcD$sp() {
                return Function0.apply$mcD$sp$((Function0)this);
            }

            public float apply$mcF$sp() {
                return Function0.apply$mcF$sp$((Function0)this);
            }

            public int apply$mcI$sp() {
                return Function0.apply$mcI$sp$((Function0)this);
            }

            public short apply$mcS$sp() {
                return Function0.apply$mcS$sp$((Function0)this);
            }

            public void apply$mcV$sp() {
                Function0.apply$mcV$sp$((Function0)this);
            }

            public String toString() {
                return Function0.toString$((Function0)this);
            }

            public HashMap<Object, Object> org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap() {
                return this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap;
            }

            public long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                long l;
                HashMap<Object, Object> hashMap = this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap();
                synchronized (hashMap) {
                    this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap().put((Object)BoxesRunTime.boxToLong((long)Thread.currentThread().getId()), (Object)BoxesRunTime.boxToLong((long)this.f$1.apply$mcJ$sp()));
                    l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$apply$1(this, x0$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                }
                return l;
            }

            public static final /* synthetic */ long $anonfun$apply$1($anon$1 $this, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long k = tuple2._1$mcJ$sp();
                long v = tuple2._2$mcJ$sp();
                long l = v - (k == $this.baseline$1._1$mcJ$sp() ? $this.baseline$1._2$mcJ$sp() : 0L);
                return l;
            }
            {
                this.f$1 = f$1;
                this.baseline$1 = baseline$1;
                Function0.$init$((Function0)this);
                this.org$apache$spark$deploy$SparkHadoopUtil$$anon$$bytesReadMap = new HashMap();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1$adapted(org.apache.spark.deploy.SparkHadoopUtil$$anon$1 scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public Function0<Object> getFSBytesWrittenOnThreadCallback() {
        Buffer threadStats = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(FileSystem.getAllStatistics()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getThreadStatistics(), Buffer$.MODULE$.canBuildFrom());
        JFunction0.mcJ.sp & Serializable & scala.Serializable f = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)threadStats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getBytesWritten()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long baselineBytesWritten = f.apply$mcJ$sp();
        return () -> SparkHadoopUtil.$anonfun$getFSBytesWrittenOnThreadCallback$4((Function0)f, baselineBytesWritten);
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, Path basePath) {
        return this.listLeafStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, FileStatus baseStatus) {
        return baseStatus.isDirectory() ? this.recurse$1(baseStatus, fs) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{baseStatus}));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, Path basePath) {
        return this.listLeafDirStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, FileStatus baseStatus) {
        Predef$.MODULE$.assert(baseStatus.isDirectory());
        return this.recurse$2(baseStatus, fs);
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains(elem)));
    }

    public Seq<Path> globPath(Path pattern) {
        FileSystem fs = pattern.getFileSystem(this.conf());
        return this.globPath(fs, pattern);
    }

    public Seq<Path> globPath(FileSystem fs, Path pattern) {
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1 & Serializable & scala.Serializable)statuses -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getPath().makeQualified(fs.getUri(), fs.getWorkingDirectory()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Seq<Path> globPathIfNecessary(Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public Seq<Path> globPathIfNecessary(FileSystem fs, Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(fs, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public FileStatus[] listFilesSorted(FileSystem remoteFs, Path dir, String prefix, String exclusionSuffix) {
        FileStatus[] fileStatusArray;
        try {
            FileStatus[] fileStatuses = remoteFs.listStatus(dir, new PathFilter(null, prefix, exclusionSuffix){
                private final String prefix$1;
                private final String exclusionSuffix$1;

                public boolean accept(Path path) {
                    String name = path.getName();
                    return name.startsWith(this.prefix$1) && !name.endsWith(this.exclusionSuffix$1);
                }
                {
                    this.prefix$1 = prefix$1;
                    this.exclusionSuffix$1 = exclusionSuffix$1;
                }
            });
            Arrays.sort((Object[])fileStatuses, new Comparator<FileStatus>(null){

                public Comparator<FileStatus> reversed() {
                    return Comparator.super.reversed();
                }

                public Comparator<FileStatus> thenComparing(Comparator<? super FileStatus> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public <U> Comparator<FileStatus> thenComparing(Function<? super FileStatus, ? extends U> x$1, Comparator<? super U> x$2) {
                    return Comparator.super.thenComparing(x$1, x$2);
                }

                public <U extends Comparable<? super U>> Comparator<FileStatus> thenComparing(Function<? super FileStatus, ? extends U> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public Comparator<FileStatus> thenComparingInt(ToIntFunction<? super FileStatus> x$1) {
                    return Comparator.super.thenComparingInt(x$1);
                }

                public Comparator<FileStatus> thenComparingLong(ToLongFunction<? super FileStatus> x$1) {
                    return Comparator.super.thenComparingLong(x$1);
                }

                public Comparator<FileStatus> thenComparingDouble(ToDoubleFunction<? super FileStatus> x$1) {
                    return Comparator.super.thenComparingDouble(x$1);
                }

                public int compare(FileStatus o1, FileStatus o2) {
                    return Longs.compare((long)o1.getModificationTime(), (long)o2.getModificationTime());
                }
            });
            fileStatusArray = fileStatuses;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while attempting to list files from application staging dir", e);
            FileStatus[] fileStatusArray2 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
            fileStatusArray = fileStatusArray2;
        }
        return fileStatusArray;
    }

    public int getSuffixForCredentialsPath(Path credentialsPath) {
        String fileName = credentialsPath.getName();
        return new StringOps(Predef$.MODULE$.augmentString(fileName.substring(fileName.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()) + 1))).toInt();
    }

    private UnanchoredRegex HADOOP_CONF_PATTERN() {
        return this.HADOOP_CONF_PATTERN;
    }

    public String substituteHadoopVariables(String text, Configuration hadoopConf) {
        String string;
        String string2 = text;
        Option option = ((Regex)this.HADOOP_CONF_PATTERN()).unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String matched = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(9).append(text).append(" matched ").append(this.HADOOP_CONF_PATTERN()).toString());
            String key = matched.substring(13, matched.length() - 1);
            Option eval = Option$.MODULE$.apply((Object)hadoopConf.get(key)).map((Function1 & Serializable & scala.Serializable)value -> {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Substituted ").append(matched).append(" with ").append((String)value).toString());
                return text.replace(matched, (CharSequence)value);
            });
            string = eval.isEmpty() ? text : this.substituteHadoopVariables((String)eval.get(), hadoopConf);
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append(text).append(" didn't match ").append(this.HADOOP_CONF_PATTERN()).toString());
            string = text;
        }
        return string;
    }

    public Iterable<String> dumpTokens(Credentials credentials) {
        return credentials != null ? (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(credentials.getAllTokens()).asScala()).map((Function1 & Serializable & scala.Serializable)token -> this.tokenToString((Token<? extends TokenIdentifier>)token), scala.collection.Iterable$.MODULE$.canBuildFrom()) : (Iterable)Seq$.MODULE$.empty();
    }

    public String tokenToString(Token<? extends TokenIdentifier> token) {
        BoxedUnit boxedUnit;
        DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(token.toString());
        try {
            BoxedUnit boxedUnit2;
            TokenIdentifier ti = token.decodeIdentifier();
            buffer.append("; ").append((Object)ti);
            TokenIdentifier tokenIdentifier = ti;
            if (tokenIdentifier instanceof AbstractDelegationTokenIdentifier) {
                AbstractDelegationTokenIdentifier abstractDelegationTokenIdentifier = (AbstractDelegationTokenIdentifier)tokenIdentifier;
                buffer.append("; Renewer: ").append((Object)abstractDelegationTokenIdentifier.getRenewer());
                buffer.append("; Issued: ").append(df.format(new Date(abstractDelegationTokenIdentifier.getIssueDate())));
                boxedUnit2 = buffer.append("; Max Date: ").append(df.format(new Date(abstractDelegationTokenIdentifier.getMaxDate())));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit = boxedUnit2;
        }
        catch (IOException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Failed to decode ").append(token).append(": ").append(e).toString(), e);
            boxedUnit = BoxedUnit.UNIT;
        }
        return buffer.toString();
    }

    public byte[] serialize(Credentials creds) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        creds.writeTokenStorageToStream(dataStream);
        return byteStream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public Credentials deserialize(byte[] tokenBytes) {
        void var3_3;
        ByteArrayInputStream tokensBuf = new ByteArrayInputStream(tokenBytes);
        Credentials creds = new Credentials();
        creds.readTokenStorageStream(new DataInputStream(tokensBuf));
        return var3_3;
    }

    public boolean isProxyUser(UserGroupInformation ugi) {
        UserGroupInformation.AuthenticationMethod authenticationMethod = ugi.getAuthenticationMethod();
        UserGroupInformation.AuthenticationMethod authenticationMethod2 = UserGroupInformation.AuthenticationMethod.PROXY;
        return !(authenticationMethod != null ? !authenticationMethod.equals(authenticationMethod2) : authenticationMethod2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hadoop.");
        return bl;
    }

    public static final /* synthetic */ long $anonfun$getFSBytesReadOnThreadCallback$2(FileSystem.Statistics x$3) {
        return x$3.getThreadStatistics().getBytesRead();
    }

    public static final /* synthetic */ long $anonfun$getFSBytesWrittenOnThreadCallback$4(Function0 f$2, long baselineBytesWritten$1) {
        return f$2.apply$mcJ$sp() - baselineBytesWritten$1;
    }

    private final Seq recurse$1(FileStatus status, FileSystem fs$1) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(status.getPath()))).partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] directories = (FileStatus[])tuple2._1();
        FileStatus[] leaves = (FileStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)directories, (Object)leaves);
        Tuple2 tuple23 = tuple22;
        FileStatus[] directories2 = (FileStatus[])tuple23._1();
        FileStatus[] leaves2 = (FileStatus[])tuple23._2();
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaves2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories2)).flatMap((Function1 & Serializable & scala.Serializable)f -> this.listLeafStatuses(fs$1, (FileStatus)f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class))))), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private final Seq recurse$2(FileStatus status, FileSystem fs$2) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$2.listStatus(status.getPath()))).partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] directories = (FileStatus[])tuple2._1();
        FileStatus[] files = (FileStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)directories, (Object)files);
        Tuple2 tuple23 = tuple22;
        FileStatus[] directories2 = (FileStatus[])tuple23._1();
        FileStatus[] files2 = (FileStatus[])tuple23._2();
        Seq leaves = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories2)).isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status})) : (Seq)Seq$.MODULE$.empty();
        return (Seq)leaves.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories2)).flatMap((Function1 & Serializable & scala.Serializable)dir -> this.listLeafDirStatuses(fs$2, (FileStatus)dir), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class))))), Seq$.MODULE$.canBuildFrom());
    }

    public SparkHadoopUtil() {
        Logging.$init$(this);
        this.sparkConf = new SparkConf(false).loadFromSystemProperties(true);
        this.conf = this.newConfiguration(this.sparkConf());
        UserGroupInformation.setConfiguration((Configuration)this.conf());
        this.HADOOP_CONF_PATTERN = new StringOps(Predef$.MODULE$.augmentString("(\\$\\{hadoopconf-[^\\}\\$\\s]+\\})")).r().unanchored();
    }
}

