/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.TorrentBroadcast$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.BroadcastBlockId$;
import org.apache.spark.storage.ByteBufferBlockData;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUb!B\u0001\u0003\u0001\u0011Q!\u0001\u0005+peJ,g\u000e\u001e\"s_\u0006$7-Y:u\u0015\t\u0019A!A\u0005ce>\fGmY1ti*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014x-\u0006\u0002\f%M!\u0001\u0001D\u0010&!\ria\u0002E\u0007\u0002\u0005%\u0011qB\u0001\u0002\n\u0005J|\u0017\rZ2bgR\u0004\"!\u0005\n\r\u0001\u0011)1\u0003\u0001b\u0001+\t\tAk\u0001\u0001\u0012\u0005Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"a\u0002(pi\"Lgn\u001a\t\u0003/uI!A\b\r\u0003\u0007\u0005s\u0017\u0010\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002%C\t9Aj\\4hS:<\u0007C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\tIwNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\u0007=\u0014'\u000eC\u00051\u0001\t\u0005\t\u0015!\u00032i\u0005\u0011\u0011\u000e\u001a\t\u0003/IJ!a\r\r\u0003\t1{gnZ\u0005\u0003a9A\u0001B\u000e\u0001\u0003\u0004\u0003\u0006YaN\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001\u001d<!5\t\u0011H\u0003\u0002;1\u00059!/\u001a4mK\u000e$\u0018B\u0001\u001f:\u0005!\u0019E.Y:t)\u0006<\u0007\"\u0002 \u0001\t\u0003y\u0014A\u0002\u001fj]&$h\bF\u0002A\u0007\u0012#\"!\u0011\"\u0011\u00075\u0001\u0001\u0003C\u00037{\u0001\u000fq\u0007C\u0003/{\u0001\u0007\u0001\u0003C\u00031{\u0001\u0007\u0011\u0007\u0003\u0005G\u0001!\u0015\r\u0011\"\u0003H\u0003\u0019yf/\u00197vKV\t\u0001\u0003\u000b\u0002F\u0013B\u0011qCS\u0005\u0003\u0017b\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u00135\u0003\u0001\u0019!a\u0001\n\u0013q\u0015\u0001E2p[B\u0014Xm]:j_:\u001cu\u000eZ3d+\u0005y\u0005cA\fQ%&\u0011\u0011\u000b\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005M+V\"\u0001+\u000b\u0005!\"\u0011B\u0001,U\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\u0006!2m\\7qe\u0016\u001c8/[8o\u0007>$WmY0%KF$\"AW/\u0011\u0005]Y\u0016B\u0001/\u0019\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0001\u0004\u0001\u0019!A!B\u0013y\u0015!E2p[B\u0014Xm]:j_:\u001cu\u000eZ3dA!\u0012q,\u0013\u0005\nG\u0002\u0001\r\u00111A\u0005\n\u0011\f\u0011B\u00197pG.\u001c\u0016N_3\u0016\u0003\u0015\u0004\"a\u00064\n\u0005\u001dD\"aA%oi\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA[\u0001\u000eE2|7m[*ju\u0016|F%Z9\u0015\u0005i[\u0007b\u00020i\u0003\u0003\u0005\r!\u001a\u0005\n[\u0002\u0001\r\u0011!Q!\n\u0015\f!B\u00197pG.\u001c\u0016N_3!Q\ta\u0017\nC\u0003q\u0001\u0011%\u0011/A\u0004tKR\u001cuN\u001c4\u0015\u0005i\u0013\b\"B:p\u0001\u0004!\u0018\u0001B2p]\u001a\u0004\"!\u001e<\u000e\u0003\u0011I!a\u001e\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007bB=\u0001\u0005\u0004%IA_\u0001\fEJ|\u0017\rZ2bgRLE-F\u0001|!\tax0D\u0001~\u0015\tqH!A\u0004ti>\u0014\u0018mZ3\n\u0007\u0005\u0005QP\u0001\tCe>\fGmY1ti\ncwnY6JI\"9\u0011Q\u0001\u0001!\u0002\u0013Y\u0018\u0001\u00042s_\u0006$7-Y:u\u0013\u0012\u0004\u0003\u0002CA\u0005\u0001\t\u0007I\u0011\u00023\u0002\u00139,XN\u00117pG.\u001c\bbBA\u0007\u0001\u0001\u0006I!Z\u0001\u000b]Vl'\t\\8dWN\u0004\u0003\"CA\t\u0001\u0001\u0007I\u0011BA\n\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$WCAA\u000b!\r9\u0012qC\u0005\u0004\u00033A\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003;\u0001\u0001\u0019!C\u0005\u0003?\t1c\u00195fG.\u001cX/\\#oC\ndW\rZ0%KF$2AWA\u0011\u0011%q\u00161DA\u0001\u0002\u0004\t)\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0015BA\u000b\u0003A\u0019\u0007.Z2lgVlWI\\1cY\u0016$\u0007\u0005C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0012!C2iK\u000e\\7/^7t+\t\ti\u0003\u0005\u0003\u0018\u0003_)\u0017bAA\u00191\t)\u0011I\u001d:bs\"Y\u0011Q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001c\u00035\u0019\u0007.Z2lgVl7o\u0018\u0013fcR\u0019!,!\u000f\t\u0013y\u000b\u0019$!AA\u0002\u00055\u0002bCA\u001f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[\t!b\u00195fG.\u001cX/\\:!\u0011\u001d\t\t\u0005\u0001C)\u0003\u0007\n\u0001bZ3u-\u0006dW/\u001a\u000b\u0002!!9\u0011q\t\u0001\u0005\n\u0005%\u0013\u0001D2bY\u000e\u001c\u0005.Z2lgVlGcA3\u0002L!A\u0011QJA#\u0001\u0004\ty%A\u0003cY>\u001c7\u000e\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)&K\u0001\u0004]&|\u0017\u0002BA-\u0003'\u0012!BQ=uK\n+hMZ3s\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\n1b\u001e:ji\u0016\u0014En\\2lgR\u0019Q-!\u0019\t\u000f\u0005\r\u00141\fa\u0001!\u0005)a/\u00197vK\"9\u0011q\r\u0001\u0005\n\u0005%\u0014A\u0003:fC\u0012\u0014En\\2lgR\u0011\u00111\u000e\t\u0006/\u0005=\u0012Q\u000e\t\u0004y\u0006=\u0014bAA9{\nI!\t\\8dW\u0012\u000bG/\u0019\u0005\b\u0003k\u0002A\u0011KA<\u0003-!w.\u00168qKJ\u001c\u0018n\u001d;\u0015\u0007i\u000bI\b\u0003\u0005\u0002|\u0005M\u0004\u0019AA\u000b\u0003!\u0011Gn\\2lS:<\u0007bBA@\u0001\u0011E\u0013\u0011Q\u0001\nI>$Um\u001d;s_f$2AWAB\u0011!\tY(! A\u0002\u0005U\u0001bBAD\u0001\u0011%\u0011\u0011R\u0001\foJLG/Z(cU\u0016\u001cG\u000fF\u0002[\u0003\u0017C\u0001\"!$\u0002\u0006\u0002\u0007\u0011qR\u0001\u0004_V$\bc\u0001\u0014\u0002\u0012&\u0019\u00111S\u0014\u0003%=\u0013'.Z2u\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003/\u0003A\u0011BA\"\u0003I\u0011X-\u00193Ce>\fGmY1ti\ncwnY6\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006Y!/\u001a7fCN,Gj\\2l)\rQ\u0016q\u0014\u0005\t\u0003C\u000bI\n1\u0001\u0002$\u00069!\r\\8dW&#\u0007c\u0001?\u0002&&\u0019\u0011qU?\u0003\u000f\tcwnY6JI\"i\u00111\u0016\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002.R\n\u0001b];qKJ$\u0013\u000eZ\u000b\u0002c\u001d9\u0011\u0011\u0017\u0002\t\n\u0005M\u0016\u0001\u0005+peJ,g\u000e\u001e\"s_\u0006$7-Y:u!\ri\u0011Q\u0017\u0004\u0007\u0003\tAI!a.\u0014\u000f\u0005U\u0016\u0011X\u0010\u0002@B\u0019q#a/\n\u0007\u0005u\u0006D\u0001\u0004B]f\u0014VM\u001a\t\u0004/\u0005\u0005\u0017B\u0001\u0017\u0019\u0011\u001dq\u0014Q\u0017C\u0001\u0003\u000b$\"!a-\t\u0011\u0005%\u0017Q\u0017C\u0001\u0003\u0017\faB\u00197pG.Lg-_(cU\u0016\u001cG/\u0006\u0003\u0002N\u0006mGCCAh\u0003;\fy.!9\u0002pR!\u0011\u0011[Aj!\u00159\u0012qFA(\u0011)\t).a2\u0002\u0002\u0003\u000f\u0011q[\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004\u0003\u0002\u001d<\u00033\u00042!EAn\t\u0019\u0019\u0012q\u0019b\u0001+!9a&a2A\u0002\u0005e\u0007BB2\u0002H\u0002\u0007Q\r\u0003\u0005\u0002d\u0006\u001d\u0007\u0019AAs\u0003)\u0019XM]5bY&TXM\u001d\t\u0005\u0003O\fY/\u0004\u0002\u0002j*\u0019\u00111\u001d\u0003\n\t\u00055\u0018\u0011\u001e\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bBB'\u0002H\u0002\u0007q\n\u0003\u0005\u0002t\u0006UF\u0011AA{\u0003A)hN\u00117pG.Lg-_(cU\u0016\u001cG/\u0006\u0003\u0002x\u0006uH\u0003CA}\u0005\u000b\u0011\tBa\u0005\u0015\t\u0005m\u0018q \t\u0004#\u0005uHAB\n\u0002r\n\u0007Q\u0003\u0003\u0006\u0003\u0002\u0005E\u0018\u0011!a\u0002\u0005\u0007\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u0011A4(a?\t\u0011\t\u001d\u0011\u0011\u001fa\u0001\u0005\u0013\taA\u00197pG.\u001c\b#B\f\u00020\t-\u0001c\u0001\u0014\u0003\u000e%\u0019!qB\u0014\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\t\u0003G\f\t\u00101\u0001\u0002f\"1Q*!=A\u0002=C\u0001Ba\u0006\u00026\u0012\u0005!\u0011D\u0001\nk:\u0004XM]:jgR$rA\u0017B\u000e\u0005;\u0011\t\u0003\u0003\u00041\u0005+\u0001\r!\r\u0005\t\u0005?\u0011)\u00021\u0001\u0002\u0016\u0005\u0001\"/Z7pm\u00164%o\\7Ee&4XM\u001d\u0005\t\u0003w\u0012)\u00021\u0001\u0002\u0016!Q!QEA[\u0003\u0003%IAa\n\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005S\u0001BAa\u000b\u000325\u0011!Q\u0006\u0006\u0004\u0005_I\u0013\u0001\u00027b]\u001eLAAa\r\u0003.\t1qJ\u00196fGR\u0004")
public class TorrentBroadcast<T>
extends Broadcast<T> {
    private transient T _value;
    private final ClassTag<T> evidence$1;
    private transient Option<CompressionCodec> compressionCodec;
    private transient int blockSize;
    private final BroadcastBlockId broadcastId;
    private final int numBlocks;
    private boolean checksumEnabled;
    private int[] checksums;
    private volatile transient boolean bitmap$trans$0;

    public static <T> T unBlockifyObject(InputStream[] inputStreamArray, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.unBlockifyObject(inputStreamArray, serializer, option, classTag);
    }

    public static <T> ByteBuffer[] blockifyObject(T t, int n, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.blockifyObject(t, n, serializer, option, classTag);
    }

    private /* synthetic */ long super$id() {
        return super.id();
    }

    private T _value$lzycompute() {
        TorrentBroadcast torrentBroadcast = this;
        synchronized (torrentBroadcast) {
            if (!this.bitmap$trans$0) {
                this._value = this.readBroadcastBlock();
                this.bitmap$trans$0 = true;
            }
        }
        return this._value;
    }

    private T _value() {
        return !this.bitmap$trans$0 ? this._value$lzycompute() : this._value;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private void compressionCodec_$eq(Option<CompressionCodec> x$1) {
        this.compressionCodec = x$1;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private void blockSize_$eq(int x$1) {
        this.blockSize = x$1;
    }

    private void setConf(SparkConf conf) {
        this.compressionCodec_$eq((Option<CompressionCodec>)(conf.getBoolean("spark.broadcast.compress", true) ? new Some((Object)CompressionCodec$.MODULE$.createCodec(conf)) : None$.MODULE$));
        this.blockSize_$eq((int)conf.getSizeAsKb("spark.broadcast.blockSize", "4m") * 1024);
        this.checksumEnabled_$eq(conf.getBoolean("spark.broadcast.checksum", true));
    }

    private BroadcastBlockId broadcastId() {
        return this.broadcastId;
    }

    private int numBlocks() {
        return this.numBlocks;
    }

    private boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    private void checksumEnabled_$eq(boolean x$1) {
        this.checksumEnabled = x$1;
    }

    private int[] checksums() {
        return this.checksums;
    }

    private void checksums_$eq(int[] x$1) {
        this.checksums = x$1;
    }

    @Override
    public T getValue() {
        return this._value();
    }

    private int calcChecksum(ByteBuffer block) {
        Adler32 adler = new Adler32();
        if (block.hasArray()) {
            adler.update(block.array(), block.arrayOffset() + block.position(), block.limit() - block.position());
        } else {
            byte[] bytes = new byte[block.remaining()];
            block.duplicate().get(bytes);
            adler.update(bytes);
        }
        return (int)adler.getValue();
    }

    private int writeBlocks(T value) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        if (!blockManager.putSingle(this.broadcastId(), value, StorageLevel$.MODULE$.MEMORY_AND_DISK(), false, this.evidence$1)) {
            throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
        }
        ByteBuffer[] blocks = TorrentBroadcast$.MODULE$.blockifyObject(value, this.blockSize(), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), this.evidence$1);
        if (this.checksumEnabled()) {
            this.checksums_$eq(new int[blocks.length]);
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TorrentBroadcast.$anonfun$writeBlocks$1(this, blockManager, x0$1);
            return BoxedUnit.UNIT;
        });
        return blocks.length;
    }

    /*
     * WARNING - void declaration
     */
    private BlockData[] readBlocks() {
        void var1_1;
        BlockData[] blocks = new BlockData[this.numBlocks()];
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        ((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numBlocks()), (Integral)Numeric.IntIsIntegral$.MODULE$), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
            BroadcastBlockId pieceId = new BroadcastBlockId(this.super$id(), new StringBuilder(5).append("piece").append(pid).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Reading piece ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
            Option<BlockData> option = bm.getLocalBytes(pieceId);
            if (option instanceof Some) {
                BlockData block;
                Some some = (Some)option;
                blocks$1[pid] = block = (BlockData)some.value();
                this.releaseLock(pieceId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                ChunkedByteBuffer b;
                Option<ChunkedByteBuffer> option2 = bm.getRemoteBytes(pieceId);
                if (option2 instanceof Some) {
                    int sum;
                    Some some = (Some)option2;
                    b = (ChunkedByteBuffer)some.value();
                    if (this.checksumEnabled() && (sum = this.calcChecksum(b.chunks()[0])) != this.checksums()[pid]) {
                        throw new SparkException(new StringBuilder(26).append("corrupt remote block ").append(pieceId).append(" of ").append(this.broadcastId()).append(":").append(new StringBuilder(5).append(" ").append(sum).append(" != ").append(this.checksums()[pid]).toString()).toString());
                    }
                    if (!bm.putBytes(pieceId, b, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                        throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append(this.broadcastId()).append(" in local BlockManager").toString());
                    }
                } else {
                    if (None$.MODULE$.equals(option2)) {
                        throw new SparkException(new StringBuilder(18).append("Failed to get ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
                    }
                    throw new MatchError(option2);
                }
                blocks$1[pid] = new ByteBufferBlockData(b, true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
        return var1_1;
    }

    @Override
    public void doUnpersist(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), false, blocking);
    }

    @Override
    public void doDestroy(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), true, blocking);
    }

    private void writeObject(ObjectOutputStream out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertValid();
            out.defaultWriteObject();
        });
    }

    private T readBroadcastBlock() {
        return Utils$.MODULE$.tryOrIOException((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            TorrentBroadcast$ torrentBroadcast$ = TorrentBroadcast$.MODULE$;
            synchronized (torrentBroadcast$) {
                ReferenceMap broadcastCache = SparkEnv$.MODULE$.get().broadcastManager().cachedValues();
                object = Option$.MODULE$.apply(broadcastCache.get((Object)this.broadcastId())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    Object object;
                    this.setConf(SparkEnv$.MODULE$.get().conf());
                    BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
                    Option<BlockResult> option = blockManager.getLocalValues(this.broadcastId());
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BlockResult blockResult = (BlockResult)some.value();
                        if (!blockResult.data().hasNext()) {
                            throw new SparkException(new StringBuilder(45).append("Failed to get locally stored broadcast data: ").append(this.broadcastId()).toString());
                        }
                        Object x = blockResult.data().next();
                        this.releaseLock(this.broadcastId());
                        Object object2 = x != null ? broadcastCache.put((Object)this.broadcastId(), x) : BoxedUnit.UNIT;
                        object = x;
                    } else if (None$.MODULE$.equals(option)) {
                        Object t;
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Started reading broadcast variable ").append(this.super$id()).toString());
                        long startTimeMs = System.currentTimeMillis();
                        BlockData[] blocks = this.readBlocks();
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Reading broadcast variable ").append(this.super$id()).append(" took").append(Utils$.MODULE$.getUsedTimeMs(startTimeMs)).toString());
                        try {
                            Object obj = TorrentBroadcast$.MODULE$.unBlockifyObject((InputStream[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toInputStream(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputStream.class))), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), $this.evidence$1);
                            StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                            if (!blockManager.putSingle(this.broadcastId(), obj, storageLevel, false, $this.evidence$1)) {
                                throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
                            }
                            Object object3 = obj != null ? broadcastCache.put((Object)this.broadcastId(), obj) : BoxedUnit.UNIT;
                            t = obj;
                        }
                        finally {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                                x$3.dispose();
                                return BoxedUnit.UNIT;
                            });
                        }
                        object = t;
                    } else {
                        throw new MatchError(option);
                    }
                    return object;
                });
            }
            return object;
        });
    }

    private void releaseLock(BlockId blockId) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        Option option = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskContext taskContext = (TaskContext)some.value();
            taskContext.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
                blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$writeBlocks$1(TorrentBroadcast $this, BlockManager blockManager$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChunkedByteBuffer bytes;
            BroadcastBlockId pieceId;
            ByteBuffer block = (ByteBuffer)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if ($this.checksumEnabled()) {
                $this.checksums()[i] = $this.calcChecksum(block);
            }
            if (!blockManager$1.putBytes(pieceId = new BroadcastBlockId($this.super$id(), new StringBuilder(5).append("piece").append(i).toString()), bytes = new ChunkedByteBuffer(block.duplicate()), StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append($this.broadcastId()).append(" in local BlockManager").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TorrentBroadcast(T obj, long id, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(id, evidence$1);
        this.setConf(SparkEnv$.MODULE$.get().conf());
        this.broadcastId = new BroadcastBlockId(super.id(), BroadcastBlockId$.MODULE$.apply$default$2());
        this.numBlocks = this.writeBlocks(obj);
        this.checksumEnabled = false;
    }
}

