/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.SparkExecutorInfoImpl;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkJobInfoImpl;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStageInfoImpl;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.MemoryMetrics;
import org.apache.spark.status.api.v1.StageStatus;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u0013\t\u00112\u000b]1sWN#\u0018\r^;t)J\f7m[3s\u0015\t\u0019A!A\u0003ta\u0006\u00148N\u0003\u0002\u0006\r\u00051\u0011\r]1dQ\u0016T\u0011aB\u0001\u0004_J<7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0005M\u001c\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!9\u0002A!A!\u0002\u0013A\u0012!B:u_J,\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u0003\u0003\u0019\u0019H/\u0019;vg&\u0011QD\u0007\u0002\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0011\u0019y\u0002\u0001\"\u0001\u0003A\u00051A(\u001b8jiz\"2!\t\u0012$!\t\u0019\u0002\u0001C\u0003\u0012=\u0001\u0007!\u0003C\u0003\u0018=\u0001\u0007\u0001\u0004C\u0003&\u0001\u0011\u0005a%A\thKRTuNY%eg\u001a{'o\u0012:pkB$\"aJ\u0017\u0011\u0007-A#&\u0003\u0002*\u0019\t)\u0011I\u001d:bsB\u00111bK\u0005\u0003Y1\u00111!\u00138u\u0011\u0015qC\u00051\u00010\u0003!QwNY$s_V\u0004\bC\u0001\u00198\u001d\t\tT\u0007\u0005\u00023\u00195\t1G\u0003\u00025\u0011\u00051AH]8pizJ!A\u000e\u0007\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m1AQa\u000f\u0001\u0005\u0002q\n\u0011cZ3u\u0003\u000e$\u0018N^3Ti\u0006<W-\u00133t)\u00059\u0003\"\u0002 \u0001\t\u0003a\u0014aD4fi\u0006\u001bG/\u001b<f\u0015>\u0014\u0017\nZ:\t\u000b\u0001\u0003A\u0011A!\u0002\u0015\u001d,GOS8c\u0013:4w\u000e\u0006\u0002C\u0011B\u00191bQ#\n\u0005\u0011c!AB(qi&|g\u000e\u0005\u0002\u0014\r&\u0011qI\u0001\u0002\r'B\f'o\u001b&pE&sgm\u001c\u0005\u0006\u0013~\u0002\rAK\u0001\u0006U>\u0014\u0017\n\u001a\u0005\u0006\u0017\u0002!\t\u0001T\u0001\rO\u0016$8\u000b^1hK&sgm\u001c\u000b\u0003\u001bF\u00032aC\"O!\t\u0019r*\u0003\u0002Q\u0005\tq1\u000b]1sWN#\u0018mZ3J]\u001a|\u0007\"\u0002*K\u0001\u0004Q\u0013aB:uC\u001e,\u0017\n\u001a\u0005\u0006)\u0002!\t!V\u0001\u0011O\u0016$X\t_3dkR|'/\u00138g_N,\u0012A\u0016\t\u0004\u0017!:\u0006CA\nY\u0013\tI&AA\tTa\u0006\u00148.\u0012=fGV$xN]%oM>\u0004")
public class SparkStatusTracker {
    private final AppStatusStore store;

    public int[] getJobIdsForGroup(String jobGroup) {
        Option expected = Option$.MODULE$.apply((Object)jobGroup);
        return (int[])((TraversableOnce)((TraversableLike)this.store.jobsList(null).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkStatusTracker.$anonfun$getJobIdsForGroup$1(expected, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.jobId()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public int[] getActiveStageIds() {
        return (int[])((TraversableOnce)this.store.stageList(Arrays.asList((Object[])new StageStatus[]{StageStatus.ACTIVE})).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.stageId()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public int[] getActiveJobIds() {
        return (int[])((TraversableOnce)this.store.jobsList(Arrays.asList((Object[])new JobExecutionStatus[]{JobExecutionStatus.RUNNING})).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.jobId()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public Option<SparkJobInfo> getJobInfo(int jobId) {
        return this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.job(jobId)).map((Function1 & Serializable & scala.Serializable)job -> new SparkJobInfoImpl(jobId, (int[])job.stageIds().toArray(ClassTag$.MODULE$.Int()), job.status()));
    }

    public Option<SparkStageInfo> getStageInfo(int stageId) {
        return this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.lastStageAttempt(stageId)).map((Function1 & Serializable & scala.Serializable)stage -> new SparkStageInfoImpl(stageId, stage.attemptId(), BoxesRunTime.unboxToLong((Object)stage.submissionTime().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), stage.name(), stage.numTasks(), stage.numActiveTasks(), stage.numCompleteTasks(), stage.numFailedTasks()));
    }

    public SparkExecutorInfo[] getExecutorInfos() {
        return (SparkExecutorInfo[])((TraversableOnce)this.store.executorList(true).map((Function1 & Serializable & scala.Serializable)exec -> {
            Tuple2 tuple2;
            String[] stringArray = exec.hostPort().split(":", 2);
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String h = (String)((SeqLike)option.get()).apply(0);
                String p = (String)((SeqLike)option.get()).apply(1);
                tuple2 = new Tuple2((Object)h, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(p)).toInt()));
            } else {
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                    String h = (String)((SeqLike)option2.get()).apply(0);
                    tuple2 = new Tuple2((Object)h, (Object)BoxesRunTime.boxToInteger((int)-1));
                } else {
                    throw new MatchError((Object)stringArray);
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String host = (String)tuple22._1();
            int port = tuple22._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            Tuple2 tuple24 = tuple23;
            String host2 = (String)tuple24._1();
            int port2 = tuple24._2$mcI$sp();
            long cachedMem = BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)mem -> BoxesRunTime.boxToLong((long)SparkStatusTracker.$anonfun$getExecutorInfos$2(mem))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new SparkExecutorInfoImpl(host2, port2, cachedMem, exec.activeTasks(), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.usedOffHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.usedOnHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.totalOffHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.totalOnHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SparkExecutorInfo.class));
    }

    public static final /* synthetic */ boolean $anonfun$getJobIdsForGroup$1(Option expected$1, JobData x$1) {
        Option<String> option = x$1.jobGroup();
        Option option2 = expected$1;
        return !(option != null ? !option.equals((Object)option2) : option2 != null);
    }

    public static final /* synthetic */ long $anonfun$getExecutorInfos$2(MemoryMetrics mem) {
        return mem.usedOnHeapStorageMemory() + mem.usedOffHeapStorageMemory();
    }

    public SparkStatusTracker(SparkContext sc, AppStatusStore store) {
        this.store = store;
    }
}

