/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Conference
extends TwiML {
    private final Boolean muted;
    private final Beep beep;
    private final Boolean startConferenceOnEnter;
    private final Boolean endConferenceOnExit;
    private final URI waitUrl;
    private final HttpMethod waitMethod;
    private final Integer maxParticipants;
    private final Record record;
    private final Region region;
    private final String whisper;
    private final Trim trim;
    private final List<Event> statusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final URI recordingStatusCallback;
    private final HttpMethod recordingStatusCallbackMethod;
    private final List<RecordingEvent> recordingStatusCallbackEvent;
    private final URI eventCallbackUrl;
    private final String name;

    private Conference() {
        this(new Builder(null));
    }

    private Conference(Builder b) {
        super("Conference", b);
        this.muted = b.muted;
        this.beep = b.beep;
        this.startConferenceOnEnter = b.startConferenceOnEnter;
        this.endConferenceOnExit = b.endConferenceOnExit;
        this.waitUrl = b.waitUrl;
        this.waitMethod = b.waitMethod;
        this.maxParticipants = b.maxParticipants;
        this.record = b.record;
        this.region = b.region;
        this.whisper = b.whisper;
        this.trim = b.trim;
        this.statusCallbackEvent = b.statusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.recordingStatusCallbackEvent = b.recordingStatusCallbackEvent;
        this.eventCallbackUrl = b.eventCallbackUrl;
        this.name = b.name;
    }

    @Override
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.isMuted() != null) {
            attrs.put("muted", this.isMuted().toString());
        }
        if (this.getBeep() != null) {
            attrs.put("beep", this.getBeep().toString());
        }
        if (this.isStartConferenceOnEnter() != null) {
            attrs.put("startConferenceOnEnter", this.isStartConferenceOnEnter().toString());
        }
        if (this.isEndConferenceOnExit() != null) {
            attrs.put("endConferenceOnExit", this.isEndConferenceOnExit().toString());
        }
        if (this.getWaitUrl() != null) {
            attrs.put("waitUrl", this.getWaitUrl().toString());
        }
        if (this.getWaitMethod() != null) {
            attrs.put("waitMethod", this.getWaitMethod().toString());
        }
        if (this.getMaxParticipants() != null) {
            attrs.put("maxParticipants", this.getMaxParticipants().toString());
        }
        if (this.getRecord() != null) {
            attrs.put("record", this.getRecord().toString());
        }
        if (this.getRegion() != null) {
            attrs.put("region", this.getRegion().toString());
        }
        if (this.getWhisper() != null) {
            attrs.put("whisper", this.getWhisper());
        }
        if (this.getTrim() != null) {
            attrs.put("trim", this.getTrim().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getRecordingStatusCallback() != null) {
            attrs.put("recordingStatusCallback", this.getRecordingStatusCallback().toString());
        }
        if (this.getRecordingStatusCallbackMethod() != null) {
            attrs.put("recordingStatusCallbackMethod", this.getRecordingStatusCallbackMethod().toString());
        }
        if (this.getRecordingStatusCallbackEvents() != null) {
            attrs.put("recordingStatusCallbackEvent", this.getRecordingStatusCallbackEventsAsString());
        }
        if (this.getEventCallbackUrl() != null) {
            attrs.put("eventCallbackUrl", this.getEventCallbackUrl().toString());
        }
        return attrs;
    }

    public Boolean isMuted() {
        return this.muted;
    }

    public Beep getBeep() {
        return this.beep;
    }

    public Boolean isStartConferenceOnEnter() {
        return this.startConferenceOnEnter;
    }

    public Boolean isEndConferenceOnExit() {
        return this.endConferenceOnExit;
    }

    public URI getWaitUrl() {
        return this.waitUrl;
    }

    public HttpMethod getWaitMethod() {
        return this.waitMethod;
    }

    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public Record getRecord() {
        return this.record;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getWhisper() {
        return this.whisper;
    }

    public Trim getTrim() {
        return this.trim;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public URI getRecordingStatusCallback() {
        return this.recordingStatusCallback;
    }

    public HttpMethod getRecordingStatusCallbackMethod() {
        return this.recordingStatusCallbackMethod;
    }

    public List<RecordingEvent> getRecordingStatusCallbackEvents() {
        return this.recordingStatusCallbackEvent;
    }

    protected String getRecordingStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<RecordingEvent> iter = this.getRecordingStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getEventCallbackUrl() {
        return this.eventCallbackUrl;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private Boolean muted;
        private Beep beep;
        private Boolean startConferenceOnEnter;
        private Boolean endConferenceOnExit;
        private URI waitUrl;
        private HttpMethod waitMethod;
        private Integer maxParticipants;
        private Record record;
        private Region region;
        private String whisper;
        private Trim trim;
        private List<Event> statusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private URI recordingStatusCallback;
        private HttpMethod recordingStatusCallbackMethod;
        private List<RecordingEvent> recordingStatusCallbackEvent;
        private URI eventCallbackUrl;
        private String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder muted(Boolean muted) {
            this.muted = muted;
            return this;
        }

        public Builder beep(Beep beep) {
            this.beep = beep;
            return this;
        }

        public Builder startConferenceOnEnter(Boolean startConferenceOnEnter) {
            this.startConferenceOnEnter = startConferenceOnEnter;
            return this;
        }

        public Builder endConferenceOnExit(Boolean endConferenceOnExit) {
            this.endConferenceOnExit = endConferenceOnExit;
            return this;
        }

        public Builder waitUrl(URI waitUrl) {
            this.waitUrl = waitUrl;
            return this;
        }

        public Builder waitUrl(String waitUrl) {
            this.waitUrl = Promoter.uriFromString(waitUrl);
            return this;
        }

        public Builder waitMethod(HttpMethod waitMethod) {
            this.waitMethod = waitMethod;
            return this;
        }

        public Builder maxParticipants(Integer maxParticipants) {
            this.maxParticipants = maxParticipants;
            return this;
        }

        public Builder record(Record record) {
            this.record = record;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder whisper(String whisper) {
            this.whisper = whisper;
            return this;
        }

        public Builder trim(Trim trim) {
            this.trim = trim;
            return this;
        }

        public Builder statusCallbackEvents(List<Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        public Builder statusCallbackEvents(Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        public Builder recordingStatusCallback(URI recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = Promoter.uriFromString(recordingStatusCallback);
            return this;
        }

        public Builder recordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        public Builder recordingStatusCallbackEvents(List<RecordingEvent> recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
            return this;
        }

        public Builder recordingStatusCallbackEvents(RecordingEvent recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = Promoter.listOfOne(recordingStatusCallbackEvent);
            return this;
        }

        public Builder eventCallbackUrl(URI eventCallbackUrl) {
            this.eventCallbackUrl = eventCallbackUrl;
            return this;
        }

        public Builder eventCallbackUrl(String eventCallbackUrl) {
            this.eventCallbackUrl = Promoter.uriFromString(eventCallbackUrl);
            return this;
        }

        public Conference build() {
            return new Conference(this);
        }
    }

    public static enum RecordingEvent {
        STARTED("started"),
        STOPPED("stopped"),
        PAUSED("paused"),
        RESUMED("resumed"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private RecordingEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Event {
        START("start"),
        END("end"),
        JOIN("join"),
        LEAVE("leave"),
        MUTE("mute"),
        HOLD("hold"),
        SPEAKER("speaker");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Region {
        US1("us1"),
        IE1("ie1"),
        SG1("sg1"),
        BR1("br1"),
        AU1("au1"),
        JP1("jp1");

        private final String value;

        private Region(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Record {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_START("record-from-start");

        private final String value;

        private Record(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Beep {
        TRUE("true"),
        FALSE("false"),
        ONENTER("onEnter"),
        ONEXIT("onExit");

        private final String value;

        private Beep(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

