/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.execution.executionstep;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.execution.executionstep.ExecutionStepContext;

public class ExecutionStepContextFetcher
extends Fetcher<ExecutionStepContext> {
    private final String pathFlowSid;
    private final String pathExecutionSid;
    private final String pathStepSid;

    public ExecutionStepContextFetcher(String pathFlowSid, String pathExecutionSid, String pathStepSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathExecutionSid = pathExecutionSid;
        this.pathStepSid = pathStepSid;
    }

    @Override
    public ExecutionStepContext fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v1/Flows/" + this.pathFlowSid + "/Executions/" + this.pathExecutionSid + "/Steps/" + this.pathStepSid + "/Context", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExecutionStepContext fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return ExecutionStepContext.fromJson(response.getStream(), client.getObjectMapper());
    }
}

