/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v1.flow.ExecutionCreator;
import com.twilio.rest.studio.v1.flow.ExecutionDeleter;
import com.twilio.rest.studio.v1.flow.ExecutionFetcher;
import com.twilio.rest.studio.v1.flow.ExecutionReader;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Execution
extends Resource {
    private static final long serialVersionUID = 259041091594783L;
    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String contactSid;
    private final String contactChannelAddress;
    private final Map<String, Object> context;
    private final Status status;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static ExecutionReader reader(String pathFlowSid) {
        return new ExecutionReader(pathFlowSid);
    }

    public static ExecutionFetcher fetcher(String pathFlowSid, String pathSid) {
        return new ExecutionFetcher(pathFlowSid, pathSid);
    }

    public static ExecutionCreator creator(String pathFlowSid, PhoneNumber to, PhoneNumber from) {
        return new ExecutionCreator(pathFlowSid, to, from);
    }

    public static ExecutionDeleter deleter(String pathFlowSid, String pathSid) {
        return new ExecutionDeleter(pathFlowSid, pathSid);
    }

    public static Execution fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Execution.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Execution fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Execution.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Execution(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="contact_sid") String contactSid, @JsonProperty(value="contact_channel_address") String contactChannelAddress, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="status") Status status, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.contactSid = contactSid;
        this.contactChannelAddress = contactChannelAddress;
        this.context = context;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getContactSid() {
        return this.contactSid;
    }

    public final String getContactChannelAddress() {
        return this.contactChannelAddress;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execution other = (Execution)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.contactSid, other.contactSid) && Objects.equals(this.contactChannelAddress, other.contactChannelAddress) && Objects.equals(this.context, other.context) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.flowSid, this.contactSid, this.contactChannelAddress, this.context, this.status, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("flowSid", this.flowSid).add("contactSid", this.contactSid).add("contactChannelAddress", this.contactChannelAddress).add("context", this.context).add("status", (Object)this.status).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).add("links", this.links).toString();
    }

    public static enum Status {
        ACTIVE("active"),
        ENDED("ended");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

