/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Engagement;

public class EngagementReader
extends Reader<Engagement> {
    private final String pathFlowSid;

    public EngagementReader(String pathFlowSid) {
        this.pathFlowSid = pathFlowSid;
    }

    @Override
    public ResourceSet<Engagement> read(TwilioRestClient client) {
        return new ResourceSet<Engagement>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Engagement> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v1/Flows/" + this.pathFlowSid + "/Engagements", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Engagement> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Engagement> nextPage(Page<Engagement> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Engagement> previousPage(Page<Engagement> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Engagement> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Engagement read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("engagements", response.getContent(), Engagement.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

