/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.Entity;

public class EntityReader
extends Reader<Entity> {
    private final String pathServiceSid;

    public EntityReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    @Override
    public ResourceSet<Entity> read(TwilioRestClient client) {
        return new ResourceSet<Entity>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Entity> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Entity> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Entity> nextPage(Page<Entity> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.AUTHY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Entity> previousPage(Page<Entity> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.AUTHY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Entity> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Entity read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("entities", response.getContent(), Entity.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

