/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront_2012_03_15.model.transform;

import com.amazonaws.services.cloudfront_2012_03_15.model.CustomOrigin;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomOriginStaxUnmarshaller
implements Unmarshaller<CustomOrigin, StaxUnmarshallerContext> {
    private static CustomOriginStaxUnmarshaller instance;

    @Override
    public CustomOrigin unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomOrigin customOrigin = new CustomOrigin();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return customOrigin;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DNSName", targetDepth)) {
                    customOrigin.setDNSName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HTTPPort", targetDepth)) {
                    customOrigin.setHTTPPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HTTPSPort", targetDepth)) {
                    customOrigin.setHTTPSPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginProtocolPolicy", targetDepth)) continue;
                customOrigin.setOriginProtocolPolicy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return customOrigin;
    }

    public static CustomOriginStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CustomOriginStaxUnmarshaller();
        }
        return instance;
    }
}

